/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.util;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.Context;
import com.tongweb.container.WebResource;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.util.Extension;
import com.tongweb.container.util.ManifestResource;
import com.tongweb.web.util.res.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public final class ExtensionValidator {
    private static final Log log = LogFactory.getLog(ExtensionValidator.class);
    private static final StringManager sm = StringManager.getManager("com.tongweb.container.util");
    private static volatile List<Extension> containerAvailableExtensions = null;
    private static final List<ManifestResource> containerManifestResources = new ArrayList<ManifestResource>();

    public static synchronized boolean validateApplication(WebResourceRoot resources, Context context) throws IOException {
        String appName = context.getName();
        ArrayList<ManifestResource> appManifestResources = new ArrayList<ManifestResource>();
        WebResource resource = resources.getResource("/META-INF/MANIFEST.MF");
        if (resource.isFile()) {
            InputStream inputStream = resource.getInputStream();
            Object object = null;
            try {
                Manifest manifest = new Manifest(inputStream);
                ManifestResource mre = new ManifestResource(sm.getString("extensionValidator.web-application-manifest"), manifest, 2);
                appManifestResources.add(mre);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        WebResource[] manifestResources = resources.getClassLoaderResources("/META-INF/MANIFEST.MF");
        for (WebResource manifestResource : manifestResources) {
            if (!manifestResource.isFile()) continue;
            String jarName = manifestResource.getURL().toExternalForm();
            Manifest jmanifest = manifestResource.getManifest();
            if (jmanifest == null) continue;
            ManifestResource mre = new ManifestResource(jarName, jmanifest, 3);
            appManifestResources.add(mre);
        }
        return ExtensionValidator.validateManifestResources(appName, appManifestResources);
    }

    public static void addSystemResource(File jarFile) throws IOException {
        try (FileInputStream is = new FileInputStream(jarFile);){
            Manifest manifest = ExtensionValidator.getManifest(is);
            if (manifest != null) {
                ManifestResource mre = new ManifestResource(jarFile.getAbsolutePath(), manifest, 1);
                containerManifestResources.add(mre);
            }
        }
    }

    private static boolean validateManifestResources(String appName, List<ManifestResource> resources) {
        boolean passes = true;
        int failureCount = 0;
        List<Extension> availableExtensions = null;
        for (ManifestResource mre : resources) {
            ArrayList<Extension> requiredList = mre.getRequiredExtensions();
            if (requiredList == null) continue;
            if (availableExtensions == null) {
                availableExtensions = ExtensionValidator.buildAvailableExtensionsList(resources);
            }
            if (containerAvailableExtensions == null) {
                containerAvailableExtensions = ExtensionValidator.buildAvailableExtensionsList(containerManifestResources);
            }
            for (Extension requiredExt : requiredList) {
                boolean found = false;
                if (availableExtensions != null) {
                    for (Extension targetExt : availableExtensions) {
                        if (!targetExt.isCompatibleWith(requiredExt)) continue;
                        requiredExt.setFulfilled(true);
                        found = true;
                        break;
                    }
                }
                if (!found && containerAvailableExtensions != null) {
                    for (Extension targetExt : containerAvailableExtensions) {
                        if (!targetExt.isCompatibleWith(requiredExt)) continue;
                        requiredExt.setFulfilled(true);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                log.info(sm.getString("extensionValidator.extension-not-found-error", appName, mre.getResourceName(), requiredExt.getExtensionName()));
                passes = false;
                ++failureCount;
            }
        }
        if (!passes) {
            log.info(sm.getString("extensionValidator.extension-validation-error", appName, failureCount + ""));
        }
        return passes;
    }

    private static List<Extension> buildAvailableExtensionsList(List<ManifestResource> resources) {
        ArrayList<Extension> availableList = null;
        for (ManifestResource mre : resources) {
            ArrayList<Extension> list = mre.getAvailableExtensions();
            if (list == null) continue;
            for (Extension ext : list) {
                if (availableList == null) {
                    availableList = new ArrayList<Extension>();
                    availableList.add(ext);
                    continue;
                }
                availableList.add(ext);
            }
        }
        return availableList;
    }

    private static Manifest getManifest(InputStream inStream) throws IOException {
        Manifest manifest = null;
        try (JarInputStream jin = new JarInputStream(inStream);){
            manifest = jin.getManifest();
        }
        return manifest;
    }

    private static void addFolderList(String property) {
        String extensionsDir = System.getProperty(property);
        if (extensionsDir != null) {
            StringTokenizer extensionsTok = new StringTokenizer(extensionsDir, File.pathSeparator);
            while (extensionsTok.hasMoreTokens()) {
                File[] files;
                File targetDir = new File(extensionsTok.nextToken());
                if (!targetDir.isDirectory() || (files = targetDir.listFiles()) == null) continue;
                for (File file : files) {
                    if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !file.isFile()) continue;
                    try {
                        ExtensionValidator.addSystemResource(file);
                    }
                    catch (IOException e2) {
                        log.error(sm.getString("extensionValidator.failload", file), e2);
                    }
                }
            }
        }
    }

    static {
        String systemClasspath = System.getProperty("java.class.path");
        StringTokenizer strTok = new StringTokenizer(systemClasspath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            File item;
            String classpathItem = strTok.nextToken();
            if (!classpathItem.toLowerCase(Locale.ENGLISH).endsWith(".jar") || !(item = new File(classpathItem)).isFile()) continue;
            try {
                ExtensionValidator.addSystemResource(item);
            }
            catch (IOException e2) {
                log.error(sm.getString("extensionValidator.failload", item), e2);
            }
        }
        ExtensionValidator.addFolderList("java.ext.dirs");
    }
}

