/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.util;

import com.tongweb.web.util.res.StringManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class NetMask {
    private static final StringManager sm = StringManager.getManager(NetMask.class);
    private final String expression;
    private final byte[] netaddr;
    private final int nrBytes;
    private final int lastByteShift;
    private final boolean foundPort;
    private final Pattern portPattern;

    public NetMask(String input) {
        int cidr;
        String nonPortPart;
        this.expression = input;
        int portIdx = input.indexOf(59);
        if (portIdx == -1) {
            this.foundPort = false;
            nonPortPart = input;
            this.portPattern = null;
        } else {
            this.foundPort = true;
            nonPortPart = input.substring(0, portIdx);
            try {
                this.portPattern = Pattern.compile(input.substring(portIdx + 1));
            }
            catch (PatternSyntaxException e2) {
                throw new IllegalArgumentException(sm.getString("netmask.invalidPort", input), e2);
            }
        }
        int idx = nonPortPart.indexOf(47);
        if (idx == -1) {
            try {
                this.netaddr = InetAddress.getByName(nonPortPart).getAddress();
            }
            catch (UnknownHostException e3) {
                throw new IllegalArgumentException(sm.getString("netmask.invalidAddress", nonPortPart));
            }
            this.nrBytes = this.netaddr.length;
            this.lastByteShift = 0;
            return;
        }
        String addressPart = nonPortPart.substring(0, idx);
        String cidrPart = nonPortPart.substring(idx + 1);
        try {
            this.netaddr = InetAddress.getByName(addressPart).getAddress();
        }
        catch (UnknownHostException e4) {
            throw new IllegalArgumentException(sm.getString("netmask.invalidAddress", addressPart));
        }
        int addrlen = this.netaddr.length * 8;
        try {
            cidr = Integer.parseInt(cidrPart);
        }
        catch (NumberFormatException e5) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrNotNumeric", cidrPart));
        }
        if (cidr < 0) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrNegative", cidrPart));
        }
        if (cidr > addrlen) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrTooBig", cidrPart, addrlen));
        }
        this.nrBytes = cidr / 8;
        int remainder = cidr % 8;
        this.lastByteShift = remainder == 0 ? 0 : 8 - remainder;
    }

    public boolean matches(InetAddress addr, int port) {
        if (!this.foundPort) {
            return false;
        }
        String portString = Integer.toString(port);
        if (!this.portPattern.matcher(portString).matches()) {
            return false;
        }
        return this.matches(addr, true);
    }

    public boolean matches(InetAddress addr) {
        return this.matches(addr, false);
    }

    public boolean matches(InetAddress addr, boolean checkedPort) {
        int i2;
        if (!checkedPort && this.foundPort) {
            return false;
        }
        byte[] candidate = addr.getAddress();
        if (candidate.length != this.netaddr.length) {
            return false;
        }
        for (i2 = 0; i2 < this.nrBytes; ++i2) {
            if (this.netaddr[i2] == candidate[i2]) continue;
            return false;
        }
        if (this.lastByteShift == 0) {
            return true;
        }
        int lastByte = this.netaddr[i2] ^ candidate[i2];
        return lastByte >> this.lastByteShift == 0;
    }

    public String toString() {
        return this.expression;
    }
}

