/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.util;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.LifecycleState;
import com.tongweb.container.SessionIdGenerator;
import com.tongweb.container.util.LifecycleBase;
import com.tongweb.web.util.res.StringManager;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class SessionIdGeneratorBase
extends LifecycleBase
implements SessionIdGenerator {
    private final Log log = LogFactory.getLog(SessionIdGeneratorBase.class);
    private static final StringManager sm = StringManager.getManager("com.tongweb.container.util");
    private final Queue<SecureRandom> randoms = new ConcurrentLinkedQueue<SecureRandom>();
    private String secureRandomClass = null;
    private String secureRandomAlgorithm = "SHA1PRNG";
    private String secureRandomProvider = null;
    private String jvmRoute = "";
    private int sessionIdLength = 16;

    public String getSecureRandomClass() {
        return this.secureRandomClass;
    }

    public void setSecureRandomClass(String secureRandomClass) {
        this.secureRandomClass = secureRandomClass;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public String getSecureRandomProvider() {
        return this.secureRandomProvider;
    }

    public void setSecureRandomProvider(String secureRandomProvider) {
        this.secureRandomProvider = secureRandomProvider;
    }

    @Override
    public String getJvmRoute() {
        return this.jvmRoute;
    }

    @Override
    public void setJvmRoute(String jvmRoute) {
        this.jvmRoute = jvmRoute;
    }

    @Override
    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    @Override
    public void setSessionIdLength(int sessionIdLength) {
        this.sessionIdLength = sessionIdLength;
    }

    @Override
    public String generateSessionId() {
        return this.generateSessionId(this.jvmRoute);
    }

    protected void getRandomBytes(byte[] bytes) {
        SecureRandom random = this.randoms.poll();
        if (random == null) {
            random = this.createSecureRandom();
        }
        random.nextBytes(bytes);
        this.randoms.add(random);
    }

    private SecureRandom createSecureRandom() {
        Random result = null;
        long t1 = System.currentTimeMillis();
        if (this.secureRandomClass != null) {
            try {
                Class<?> clazz = Class.forName(this.secureRandomClass);
                result = (SecureRandom)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e2) {
                this.log.error(sm.getString("sessionIdGeneratorBase.random", this.secureRandomClass), e2);
            }
        }
        boolean error = false;
        if (result == null) {
            try {
                if (this.secureRandomProvider != null && this.secureRandomProvider.length() > 0) {
                    result = SecureRandom.getInstance(this.secureRandomAlgorithm, this.secureRandomProvider);
                } else if (this.secureRandomAlgorithm != null && this.secureRandomAlgorithm.length() > 0) {
                    result = SecureRandom.getInstance(this.secureRandomAlgorithm);
                }
            }
            catch (NoSuchAlgorithmException e3) {
                error = true;
                this.log.error(sm.getString("sessionIdGeneratorBase.randomAlgorithm", this.secureRandomAlgorithm), e3);
            }
            catch (NoSuchProviderException e4) {
                error = true;
                this.log.error(sm.getString("sessionIdGeneratorBase.randomProvider", this.secureRandomProvider), e4);
            }
        }
        if (result == null && error) {
            try {
                result = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e5) {
                this.log.error(sm.getString("sessionIdGeneratorBase.randomAlgorithm", this.secureRandomAlgorithm), e5);
            }
        }
        if (result == null) {
            result = new SecureRandom();
        }
        result.nextInt();
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 100L) {
            this.log.warn(sm.getString("sessionIdGeneratorBase.createRandom", ((SecureRandom)result).getAlgorithm(), t2 - t1));
        }
        return result;
    }

    @Override
    protected void initInternal() throws LifecycleException {
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.generateSessionId();
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.randoms.clear();
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
    }
}

