/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.valves;

import com.tongweb.container.connector.Request;
import com.tongweb.container.connector.Response;
import com.tongweb.container.valves.ValveBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;

public class FilterValue
extends ValveBase {
    private String manageContextPath;
    private List<String> accessIpList = new ArrayList<String>();
    private List<String> blockedIpList = new ArrayList<String>();

    public FilterValue(Properties manageWebProperties) {
        this.manageContextPath = manageWebProperties.getProperty("contextPath");
        String access_iplist = manageWebProperties.getProperty("access_iplist");
        String blocked_iplist = manageWebProperties.getProperty("blocked_iplist");
        if (null != access_iplist && !access_iplist.isEmpty()) {
            this.accessIpList = Arrays.asList(access_iplist.split(","));
        }
        if (null != blocked_iplist && !blocked_iplist.isEmpty()) {
            this.blockedIpList = Arrays.asList(blocked_iplist.split(","));
        }
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String requestContextPath = request.getServletPath();
        String realIP = FilterValue.getRealIP(request);
        if (requestContextPath.startsWith(this.manageContextPath) && !realIP.isEmpty()) {
            if (this.isAllowed(realIP)) {
                this.getNext().invoke(request, response);
                return;
            }
            response.sendError(403);
            return;
        }
        this.getNext().invoke(request, response);
    }

    public boolean isAllowed(String realIp) {
        if (this.accessIpList.isEmpty() && this.blockedIpList.isEmpty()) {
            return true;
        }
        if (!this.accessIpList.isEmpty()) {
            for (int i2 = 0; i2 < this.accessIpList.size(); ++i2) {
                if (!FilterValue.checkIPMatching(this.accessIpList.get(i2), realIp)) continue;
                return true;
            }
            return false;
        }
        if (!this.blockedIpList.isEmpty()) {
            for (int i3 = 0; i3 < this.blockedIpList.size(); ++i3) {
                if (!FilterValue.checkIPMatching(this.blockedIpList.get(i3), realIp)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean checkIPMatching(String pattern, String address) {
        String[] mask = pattern.split("\\.");
        String[] ip_address = address.split("\\.");
        for (int i2 = 0; i2 < mask.length; ++i2) {
            if (mask[i2].equals("*") || mask[i2].equals(ip_address[i2])) continue;
            if (mask[i2].contains("-")) {
                short min = Short.parseShort(mask[i2].split("-")[0]);
                short max = Short.parseShort(mask[i2].split("-")[1]);
                short ip = Short.parseShort(ip_address[i2]);
                if (ip >= min && ip <= max) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static String getRealIP(Request request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip) && ip.indexOf(",") != -1) {
            ip = ip.split(",")[0];
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.contains(",")) {
            String[] ipArray = ip.split(",");
            ip = ipArray[0];
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }
}

