/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.buildutil.translate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class Utils {
    private static final Pattern ESCAPE_LEADING_SPACE = Pattern.compile("^(\\s)", 8);
    static final String PADDING = "POEDITOR_EXPORT_PADDING_DO_NOT_DELETE";

    private Utils() {
    }

    static String getLanguage(String name) {
        return name.substring("LocalStrings".length(), name.length() - ".properties".length());
    }

    static Properties load(File f2) {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(f2);
             InputStreamReader r = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
            props.load(r);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return props;
    }

    static String formatValueExport(String in) {
        String result = in.startsWith("\n") ? PADDING + in : in;
        return Utils.formatValueCommon(result);
    }

    static String formatValueImport(String in) {
        String result = in.startsWith(PADDING) ? in.substring(PADDING.length()) : in;
        return Utils.formatValueCommon(result);
    }

    static String formatValueCommon(String in) {
        String result = in.replace("\n", "\\n\\\n");
        if (result.endsWith("\\n\\\n")) {
            result = result.substring(0, result.length() - 2);
        }
        result = ESCAPE_LEADING_SPACE.matcher(result).replaceAll("\\\\$1");
        result = result.replaceAll("\t", "\\t");
        return result;
    }

    static void processDirectory(File root, File dir, Map<String, Properties> translations) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Not a directory [" + dir.getAbsolutePath() + "]");
        }
        for (File f2 : files) {
            if (f2.isDirectory()) {
                Utils.processDirectory(root, f2, translations);
                continue;
            }
            if (!f2.isFile()) continue;
            Utils.processFile(root, f2, translations);
        }
    }

    static void processFile(File root, File f2, Map<String, Properties> translations) throws IOException {
        String name = f2.getName();
        if (!name.startsWith("LocalStrings")) {
            return;
        }
        String language = Utils.getLanguage(name);
        String keyPrefix = Utils.getKeyPrefix(root, f2);
        Properties props = Utils.load(f2);
        Properties translation = translations.get(language);
        if (translation == null) {
            translation = new Properties();
            translations.put(language, translation);
        }
        for (Object obj : props.keySet()) {
            String key = (String)obj;
            String value = props.getProperty(key);
            translation.put(keyPrefix + key, value);
        }
    }

    static String getKeyPrefix(File root, File f2) throws IOException {
        String prefix = f2.getParentFile().getCanonicalPath();
        prefix = prefix.substring(root.getCanonicalPath().length() + 1);
        prefix = prefix.replace(File.separatorChar, '.');
        prefix = prefix + ".zzz.";
        return prefix;
    }

    static void export(String language, Properties translation, File storageDir) {
        File out = new File(storageDir, "LocalStrings" + language + ".properties");
        try (FileOutputStream fos = new FileOutputStream(out);
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
            Object[] keys = translation.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                w.write(key + "=" + Utils.formatValueExport(translation.getProperty((String)key)) + "\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

