/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.dbcp.dbcp2.managed;

import com.tongweb.web.dbcp.dbcp2.managed.TransactionContextListener;
import com.tongweb.web.dbcp.dbcp2.managed.TransactionRegistry;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;

public class TransactionContext {
    private final TransactionRegistry transactionRegistry;
    private final WeakReference<Transaction> transactionRef;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private Connection sharedConnection;
    private boolean transactionComplete;

    public TransactionContext(TransactionRegistry transactionRegistry, Transaction transaction) {
        this(transactionRegistry, transaction, null);
    }

    public TransactionContext(TransactionRegistry transactionRegistry, Transaction transaction, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Objects.requireNonNull(transactionRegistry, "transactionRegistry is null");
        Objects.requireNonNull(transaction, "transaction is null");
        this.transactionRegistry = transactionRegistry;
        this.transactionRef = new WeakReference<Transaction>(transaction);
        this.transactionComplete = false;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
    }

    public void addTransactionContextListener(final TransactionContextListener listener) throws SQLException {
        try {
            if (!this.isActive()) {
                Transaction transaction = (Transaction)this.transactionRef.get();
                listener.afterCompletion(this, transaction != null && transaction.getStatus() == 3);
                return;
            }
            Synchronization s = new Synchronization(){

                @Override
                public void afterCompletion(int status) {
                    listener.afterCompletion(TransactionContext.this, status == 3);
                }

                @Override
                public void beforeCompletion() {
                }
            };
            if (this.transactionSynchronizationRegistry != null) {
                this.transactionSynchronizationRegistry.registerInterposedSynchronization(s);
            } else {
                this.getTransaction().registerSynchronization(s);
            }
        }
        catch (RollbackException s) {
        }
        catch (Exception e2) {
            throw new SQLException("Unable to register transaction context listener", e2);
        }
    }

    public void completeTransaction() {
        this.transactionComplete = true;
    }

    public Connection getSharedConnection() {
        return this.sharedConnection;
    }

    private Transaction getTransaction() throws SQLException {
        Transaction transaction = (Transaction)this.transactionRef.get();
        if (transaction == null) {
            throw new SQLException("Unable to enlist connection because the transaction has been garbage collected");
        }
        return transaction;
    }

    public boolean isActive() throws SQLException {
        try {
            Transaction transaction = (Transaction)this.transactionRef.get();
            if (transaction == null) {
                return false;
            }
            int status = transaction.getStatus();
            return status == 0 || status == 1;
        }
        catch (SystemException e2) {
            throw new SQLException("Unable to get transaction status", e2);
        }
    }

    public boolean isTransactionComplete() {
        return this.transactionComplete;
    }

    public void setSharedConnection(Connection sharedConnection) throws SQLException {
        if (this.sharedConnection != null) {
            throw new IllegalStateException("A shared connection is already set");
        }
        Transaction transaction = this.getTransaction();
        try {
            XAResource xaResource = this.transactionRegistry.getXAResource(sharedConnection);
            if (!transaction.enlistResource(xaResource)) {
                throw new SQLException("Unable to enlist connection in transaction: enlistResource returns 'false'.");
            }
        }
        catch (IllegalStateException e2) {
            throw new SQLException("Unable to enlist connection in the transaction", e2);
        }
        catch (RollbackException e2) {
        }
        catch (SystemException e3) {
            throw new SQLException("Unable to enlist connection the transaction", e3);
        }
        this.sharedConnection = sharedConnection;
    }
}

