/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.bcel.classfile;

import com.tongweb.web.util.bcel.Const;
import com.tongweb.web.util.bcel.classfile.ClassFormatException;
import com.tongweb.web.util.bcel.classfile.Constant;
import java.io.DataInput;
import java.io.IOException;

public class ConstantPool {
    private final Constant[] constantPool;

    ConstantPool(DataInput input) throws IOException, ClassFormatException {
        int constant_pool_count = input.readUnsignedShort();
        this.constantPool = new Constant[constant_pool_count];
        for (int i2 = 1; i2 < constant_pool_count; ++i2) {
            byte tag;
            this.constantPool[i2] = Constant.readConstant(input);
            if (this.constantPool[i2] == null || (tag = this.constantPool[i2].getTag()) != 6 && tag != 5) continue;
            ++i2;
        }
    }

    public Constant getConstant(int index) {
        if (index >= this.constantPool.length || index < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index + ". Constant pool size is: " + this.constantPool.length);
        }
        return this.constantPool[index];
    }

    public Constant getConstant(int index, byte tag) throws ClassFormatException {
        Constant c2 = this.getConstant(index);
        if (c2 == null) {
            throw new ClassFormatException("Constant pool at index " + index + " is null.");
        }
        if (c2.getTag() != tag) {
            throw new ClassFormatException("Expected class `" + Const.getConstantName(tag) + "' at index " + index + " and got " + c2);
        }
        return c2;
    }
}

