/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.bcel.classfile;

import com.tongweb.web.util.bcel.classfile.ConstantDouble;
import com.tongweb.web.util.bcel.classfile.ConstantFloat;
import com.tongweb.web.util.bcel.classfile.ConstantInteger;
import com.tongweb.web.util.bcel.classfile.ConstantLong;
import com.tongweb.web.util.bcel.classfile.ConstantPool;
import com.tongweb.web.util.bcel.classfile.ConstantUtf8;
import com.tongweb.web.util.bcel.classfile.ElementValue;

public class SimpleElementValue
extends ElementValue {
    private final int index;

    SimpleElementValue(int type, int index, ConstantPool cpool) {
        super(type, cpool);
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String stringifyValue() {
        ConstantPool cpool = super.getConstantPool();
        int _type = super.getType();
        switch (_type) {
            case 73: {
                ConstantInteger c2 = (ConstantInteger)cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(c2.getBytes());
            }
            case 74: {
                ConstantLong j2 = (ConstantLong)cpool.getConstant(this.getIndex(), (byte)5);
                return Long.toString(j2.getBytes());
            }
            case 68: {
                ConstantDouble d2 = (ConstantDouble)cpool.getConstant(this.getIndex(), (byte)6);
                return Double.toString(d2.getBytes());
            }
            case 70: {
                ConstantFloat f2 = (ConstantFloat)cpool.getConstant(this.getIndex(), (byte)4);
                return Float.toString(f2.getBytes());
            }
            case 83: {
                ConstantInteger s = (ConstantInteger)cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(s.getBytes());
            }
            case 66: {
                ConstantInteger b2 = (ConstantInteger)cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(b2.getBytes());
            }
            case 67: {
                ConstantInteger ch = (ConstantInteger)cpool.getConstant(this.getIndex(), (byte)3);
                return String.valueOf((char)ch.getBytes());
            }
            case 90: {
                ConstantInteger bo = (ConstantInteger)cpool.getConstant(this.getIndex(), (byte)3);
                if (bo.getBytes() == 0) {
                    return "false";
                }
                return "true";
            }
            case 115: {
                ConstantUtf8 cu8 = (ConstantUtf8)cpool.getConstant(this.getIndex(), (byte)1);
                return cu8.getBytes();
            }
        }
        throw new IllegalStateException("SimpleElementValue class does not know how to stringify type " + _type);
    }
}

