/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.descriptor.web;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.web.util.descriptor.DigesterFactory;
import com.tongweb.web.util.descriptor.InputSourceUtil;
import com.tongweb.web.util.descriptor.XmlErrorHandler;
import com.tongweb.web.util.descriptor.web.Constants;
import com.tongweb.web.util.descriptor.web.WebRuleSet;
import com.tongweb.web.util.descriptor.web.WebXml;
import com.tongweb.web.util.digester.Digester;
import com.tongweb.web.util.res.StringManager;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class WebXmlParser {
    private final Log log = LogFactory.getLog(WebXmlParser.class);
    private static final StringManager sm = StringManager.getManager(Constants.PACKAGE_NAME);
    private final Digester webDigester;
    private final WebRuleSet webRuleSet = new WebRuleSet(false);
    private final Digester webFragmentDigester;
    private final WebRuleSet webFragmentRuleSet;

    public WebXmlParser(boolean namespaceAware, boolean validation, boolean blockExternal) {
        this.webDigester = DigesterFactory.newDigester(validation, namespaceAware, this.webRuleSet, blockExternal);
        this.webDigester.getParser();
        this.webFragmentRuleSet = new WebRuleSet(true);
        this.webFragmentDigester = DigesterFactory.newDigester(validation, namespaceAware, this.webFragmentRuleSet, blockExternal);
        this.webFragmentDigester.getParser();
    }

    public boolean parseWebXml(URL url, WebXml dest, boolean fragment) throws IOException {
        if (url == null) {
            return true;
        }
        InputSource source = new InputSource(url.toExternalForm());
        source.setByteStream(url.openStream());
        return this.parseWebXml(source, dest, fragment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseWebXml(InputSource source, WebXml dest, boolean fragment) {
        WebRuleSet ruleSet;
        Digester digester;
        boolean ok = true;
        if (source == null) {
            return ok;
        }
        XmlErrorHandler handler = new XmlErrorHandler();
        if (fragment) {
            digester = this.webFragmentDigester;
            ruleSet = this.webFragmentRuleSet;
        } else {
            digester = this.webDigester;
            ruleSet = this.webRuleSet;
        }
        digester.push(dest);
        digester.setErrorHandler(handler);
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("webXmlParser.applicationStart", source.getSystemId()));
        }
        try {
            digester.parse(source);
            if (handler.getWarnings().size() > 0 || handler.getErrors().size() > 0) {
                ok = false;
                handler.logFindings(this.log, source.getSystemId());
            }
        }
        catch (SAXParseException e2) {
            this.log.error(sm.getString("webXmlParser.applicationParse", source.getSystemId()), e2);
            this.log.error(sm.getString("webXmlParser.applicationPosition", "" + e2.getLineNumber(), "" + e2.getColumnNumber()));
            ok = false;
        }
        catch (Exception e3) {
            this.log.error(sm.getString("webXmlParser.applicationParse", source.getSystemId()), e3);
            ok = false;
        }
        finally {
            InputSourceUtil.close(source);
            digester.reset();
            ruleSet.recycle();
        }
        return ok;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.webDigester.setClassLoader(classLoader);
        this.webFragmentDigester.setClassLoader(classLoader);
    }
}

