/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.file;

import com.tongweb.web.util.buf.UriUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public interface ConfigurationSource {
    public static final ConfigurationSource DEFAULT = new ConfigurationSource(){
        protected final File userDir = new File(System.getProperty("user.dir"));
        protected final URI userDirUri = this.userDir.toURI();

        @Override
        public Resource getResource(String name) throws IOException {
            if (!UriUtil.isAbsoluteURI(name)) {
                File f2 = new File(name);
                if (!f2.isAbsolute()) {
                    f2 = new File(this.userDir, name);
                }
                if (f2.isFile()) {
                    FileInputStream fis = new FileInputStream(f2);
                    return new Resource(fis, f2.toURI());
                }
            }
            URI uri = null;
            try {
                uri = this.userDirUri.resolve(name);
            }
            catch (IllegalArgumentException e2) {
                throw new FileNotFoundException(name);
            }
            try {
                URL url = uri.toURL();
                return new Resource(url.openConnection().getInputStream(), uri);
            }
            catch (MalformedURLException e3) {
                throw new FileNotFoundException(name);
            }
        }

        @Override
        public URI getURI(String name) {
            if (!UriUtil.isAbsoluteURI(name)) {
                File f2 = new File(name);
                if (!f2.isAbsolute()) {
                    f2 = new File(this.userDir, name);
                }
                if (f2.isFile()) {
                    return f2.toURI();
                }
            }
            return this.userDirUri.resolve(name);
        }
    };

    default public Resource getServerXml() throws IOException {
        return this.getConfResource("server.xml");
    }

    default public Resource getSharedWebXml() throws IOException {
        return this.getConfResource("web.xml");
    }

    default public Resource getConfResource(String name) throws IOException {
        String fullName = "conf/" + name;
        return this.getResource(fullName);
    }

    public Resource getResource(String var1) throws IOException;

    public URI getURI(String var1);

    public static class Resource
    implements AutoCloseable {
        private final InputStream inputStream;
        private final URI uri;

        public Resource(InputStream inputStream, URI uri) {
            this.inputStream = inputStream;
            this.uri = uri;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public URI getURI() {
            return this.uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastModified() throws MalformedURLException, IOException {
            URLConnection connection = null;
            try {
                connection = this.uri.toURL().openConnection();
                long l = connection.getLastModified();
                return l;
            }
            finally {
                if (connection != null) {
                    connection.getInputStream().close();
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }
}

