/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.file;

import java.util.Set;

public final class Matcher {
    public static boolean matchName(Set<String> patternSet, String fileName) {
        char[] fileNameArray = fileName.toCharArray();
        for (String pattern : patternSet) {
            if (!Matcher.match(pattern, fileNameArray, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean match(String pattern, String str, boolean caseSensitive) {
        return Matcher.match(pattern, str.toCharArray(), caseSensitive);
    }

    private static boolean match(String pattern, char[] strArr, boolean caseSensitive) {
        char ch;
        char[] patArr = pattern.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (char c2 : patArr) {
            if (c2 != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i2 = 0; i2 <= patIdxEnd; ++i2) {
                char ch2 = patArr[i2];
                if (ch2 == '?' || !Matcher.different(caseSensitive, ch2, strArr[i2])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && Matcher.different(caseSensitive, ch, strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            return Matcher.allStars(patArr, patIdxStart, patIdxEnd);
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && Matcher.different(caseSensitive, ch, strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            return Matcher.allStars(patArr, patIdxStart, patIdxEnd);
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i3 = patIdxStart + 1; i3 <= patIdxEnd; ++i3) {
                if (patArr[i3] != '*') continue;
                patIdxTmp = i3;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i4 = 0; i4 <= strLength - patLength; ++i4) {
                for (int j2 = 0; j2 < patLength; ++j2) {
                    ch = patArr[patIdxStart + j2 + 1];
                    if (ch != '?' && Matcher.different(caseSensitive, ch, strArr[strIdxStart + i4 + j2])) continue block6;
                }
                foundIdx = strIdxStart + i4;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        return Matcher.allStars(patArr, patIdxStart, patIdxEnd);
    }

    private static boolean allStars(char[] chars, int start, int end) {
        for (int i2 = start; i2 <= end; ++i2) {
            if (chars[i2] == '*') continue;
            return false;
        }
        return true;
    }

    private static boolean different(boolean caseSensitive, char ch, char other) {
        return caseSensitive ? ch != other : Character.toUpperCase(ch) != Character.toUpperCase(other);
    }
}

