/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.http.parser;

import com.tongweb.web.util.collections.ConcurrentCache;
import com.tongweb.web.util.http.parser.MediaType;
import java.io.IOException;
import java.io.StringReader;

public class MediaTypeCache {
    private final ConcurrentCache<String, String[]> cache;

    public MediaTypeCache(int size) {
        this.cache = new ConcurrentCache(size);
    }

    public String[] parse(String input) {
        String[] result = this.cache.get(input);
        if (result != null) {
            return result;
        }
        MediaType m = null;
        try {
            m = MediaType.parseMediaType(new StringReader(input));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (m != null) {
            result = new String[]{m.toStringNoCharset(), m.getCharset()};
            this.cache.put(input, result);
        }
        return result;
    }
}

