/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.log;

import com.tongweb.web.util.log.CaptureLog;
import java.io.IOException;
import java.io.PrintStream;
import java.util.EmptyStackException;
import java.util.Stack;

public class SystemLogHandler
extends PrintStream {
    private final PrintStream out;
    private static final ThreadLocal<Stack<CaptureLog>> logs = new ThreadLocal();
    private static final Stack<CaptureLog> reuse = new Stack();

    public SystemLogHandler(PrintStream wrapped) {
        super(wrapped);
        this.out = wrapped;
    }

    public static void startCapture() {
        Stack<CaptureLog> stack;
        CaptureLog log = null;
        if (!reuse.isEmpty()) {
            try {
                log = reuse.pop();
            }
            catch (EmptyStackException e2) {
                log = new CaptureLog();
            }
        } else {
            log = new CaptureLog();
        }
        if ((stack = logs.get()) == null) {
            stack = new Stack();
            logs.set(stack);
        }
        stack.push(log);
    }

    public static String stopCapture() {
        Stack<CaptureLog> stack = logs.get();
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        CaptureLog log = stack.pop();
        if (log == null) {
            return null;
        }
        String capture = log.getCapture();
        log.reset();
        reuse.push(log);
        return capture;
    }

    protected PrintStream findStream() {
        PrintStream ps;
        CaptureLog log;
        Stack<CaptureLog> stack = logs.get();
        if (stack != null && !stack.isEmpty() && (log = stack.peek()) != null && (ps = log.getStream()) != null) {
            return ps;
        }
        return this.out;
    }

    @Override
    public void flush() {
        this.findStream().flush();
    }

    @Override
    public void close() {
        this.findStream().close();
    }

    @Override
    public boolean checkError() {
        return this.findStream().checkError();
    }

    @Override
    protected void setError() {
    }

    @Override
    public void write(int b2) {
        this.findStream().write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.findStream().write(b2);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.findStream().write(buf, off, len);
    }

    @Override
    public void print(boolean b2) {
        this.findStream().print(b2);
    }

    @Override
    public void print(char c2) {
        this.findStream().print(c2);
    }

    @Override
    public void print(int i2) {
        this.findStream().print(i2);
    }

    @Override
    public void print(long l) {
        this.findStream().print(l);
    }

    @Override
    public void print(float f2) {
        this.findStream().print(f2);
    }

    @Override
    public void print(double d2) {
        this.findStream().print(d2);
    }

    @Override
    public void print(char[] s) {
        this.findStream().print(s);
    }

    @Override
    public void print(String s) {
        this.findStream().print(s);
    }

    @Override
    public void print(Object obj) {
        this.findStream().print(obj);
    }

    @Override
    public void println() {
        this.findStream().println();
    }

    @Override
    public void println(boolean x) {
        this.findStream().println(x);
    }

    @Override
    public void println(char x) {
        this.findStream().println(x);
    }

    @Override
    public void println(int x) {
        this.findStream().println(x);
    }

    @Override
    public void println(long x) {
        this.findStream().println(x);
    }

    @Override
    public void println(float x) {
        this.findStream().println(x);
    }

    @Override
    public void println(double x) {
        this.findStream().println(x);
    }

    @Override
    public void println(char[] x) {
        this.findStream().println(x);
    }

    @Override
    public void println(String x) {
        this.findStream().println(x);
    }

    @Override
    public void println(Object x) {
        this.findStream().println(x);
    }
}

