/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.net.gmjsse;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.web.util.net.SSLSessionManager;
import com.tongweb.web.util.net.SSLSupport;
import com.tongweb.web.util.net.gmjsse.GMConstant;
import com.tongweb.web.util.net.openssl.ciphers.Cipher;
import com.tongweb.web.util.res.StringManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSession;

public class GMSupport
implements SSLSupport,
SSLSessionManager {
    private static final Log log = LogFactory.getLog(GMSupport.class);
    private static final StringManager sm = StringManager.getManager(GMSupport.class);
    private static final Map<String, Integer> keySizeCache = new HashMap<String, Integer>();
    private SSLSession session;

    static void init() {
        try {
            Class<?> jceClzz = Class.forName(GMConstant.GM_JCE_CLASS_NAME);
            Class<?> pClazz = Class.forName(GMConstant.GM_PROVIDER_CLASS_NAME);
            Provider jce = (Provider)jceClzz.newInstance();
            Provider provider = (Provider)pClazz.newInstance();
            Security.insertProviderAt(jce, 1);
            Security.insertProviderAt(provider, 2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        System.setProperty("ecc_server_key_exchange", "true");
    }

    public GMSupport(SSLSession paramSSLSession) {
        this.session = paramSSLSession;
    }

    @Override
    public String getCipherSuite() throws IOException {
        return this.session == null ? null : this.session.getCipherSuite();
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws IOException {
        if (this.session == null) {
            return null;
        }
        Certificate[] certs = null;
        try {
            certs = this.session.getPeerCertificates();
        }
        catch (Throwable throwable) {
            log.debug(sm.getString("jsseSupport.clientCertError"), throwable);
            return null;
        }
        if (certs == null) {
            return null;
        }
        X509Certificate[] x509Certificates = new X509Certificate[certs.length];
        for (int i2 = 0; i2 < certs.length; ++i2) {
            if (certs[i2] instanceof X509Certificate) {
                x509Certificates[i2] = (X509Certificate)certs[i2];
            } else {
                try {
                    byte[] encoded = certs[i2].getEncoded();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(encoded);
                    x509Certificates[i2] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                }
                catch (Exception exception) {
                    log.info(sm.getString("jsseSupport.certTranslationError", certs[i2]), exception);
                    return null;
                }
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("Cert #" + i2 + " = " + x509Certificates[i2]);
        }
        return x509Certificates.length < 1 ? null : x509Certificates;
    }

    @Override
    public Integer getKeySize() throws IOException {
        return this.session == null ? null : keySizeCache.get(this.session.getCipherSuite());
    }

    @Override
    public String getSessionId() throws IOException {
        if (this.session == null) {
            return null;
        }
        byte[] ids = this.session.getId();
        if (ids == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < ids.length; ++i2) {
            byte id = ids[i2];
            String str = Integer.toHexString(id);
            if (str.length() < 2) {
                builder.append('0');
            }
            if (str.length() > 2) {
                str = str.substring(str.length() - 2);
            }
            builder.append(str);
        }
        return builder.toString();
    }

    public void setSession(SSLSession paramSSLSession) {
        this.session = paramSSLSession;
    }

    @Override
    public void invalidateSession() {
        this.session.invalidate();
    }

    @Override
    public String getProtocol() throws IOException {
        return this.session == null ? null : this.session.getProtocol();
    }

    @Override
    public String getRequestedProtocols() throws IOException {
        return null;
    }

    @Override
    public String getRequestedCiphers() throws IOException {
        return null;
    }

    static {
        Cipher[] ciphers = Cipher.values();
        int i2 = ciphers.length;
        for (int b2 = 0; b2 < i2; ++b2) {
            try {
                Cipher cipher = ciphers[b2];
                for (String str : cipher.getJsseNames()) {
                    keySizeCache.put(str, cipher.getStrength_bits());
                }
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

