/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.xreflection;

import com.tongweb.web.util.IntrospectionUtils;
import com.tongweb.web.util.xreflection.ReflectionLessCodeGenerator;
import com.tongweb.web.util.xreflection.ReflectionProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;

final class SetPropertyClass
implements Comparable<SetPropertyClass> {
    static final String OBJECT_VAR_NAME = "o";
    static final String NAME_VAR_NAME = "name";
    static final String VALUE_VAR_NAME = "value";
    static final String SETP_VAR_NAME = "invokeSetProperty";
    private final SetPropertyClass parent;
    private final Class<?> clazz;
    private Set<SetPropertyClass> children = new TreeSet<SetPropertyClass>();
    private Set<ReflectionProperty> properties = new TreeSet<ReflectionProperty>();
    private final boolean isAbstract;
    private final Method genericSetPropertyMethod;
    private final Method genericGetPropertyMethod;

    SetPropertyClass(Class<?> clazz, SetPropertyClass parent) {
        Method classGetter;
        Method classSetter;
        this.clazz = clazz;
        this.parent = parent;
        this.isAbstract = Modifier.isAbstract(clazz.getModifiers());
        try {
            classSetter = clazz.getDeclaredMethod("setProperty", String.class, String.class);
        }
        catch (NoSuchMethodException e2) {
            try {
                classSetter = clazz.getDeclaredMethod("setProperty", String.class, Object.class);
            }
            catch (NoSuchMethodException x) {
                classSetter = null;
            }
        }
        try {
            classGetter = clazz.getDeclaredMethod("getProperty", String.class);
        }
        catch (NoSuchMethodException e3) {
            classGetter = null;
        }
        this.genericSetPropertyMethod = classSetter;
        this.genericGetPropertyMethod = classGetter;
    }

    boolean isAbstract() {
        return this.isAbstract;
    }

    void addSubClass(SetPropertyClass clazz) {
        this.children.add(clazz);
    }

    boolean isBaseClass() {
        return this.parent == null;
    }

    public Set<SetPropertyClass> getChildren() {
        return this.children;
    }

    public Set<ReflectionProperty> getProperties() {
        return this.properties;
    }

    public Method getGenericSetPropertyMethod() {
        return this.genericSetPropertyMethod;
    }

    public Method getGenericGetPropertyMethod() {
        return this.genericGetPropertyMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetPropertyClass that = (SetPropertyClass)o;
        return this.clazz.equals(that.clazz);
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public SetPropertyClass getParent() {
        return this.parent;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SetPropertyClass{");
        sb.append("clazz=").append(this.clazz.getName());
        sb.append('}');
        return sb.toString();
    }

    public void addProperty(ReflectionProperty property) {
        this.properties.add(property);
    }

    public String generateSetPropertyMethod(ReflectionProperty property) {
        if (property.hasSetPropertySetter()) {
            return "((" + this.getClazz().getName().replace('$', '.') + ")" + OBJECT_VAR_NAME + ")." + property.getSetMethod().getName() + "(" + NAME_VAR_NAME + ", " + VALUE_VAR_NAME + ");";
        }
        if (property.hasSetter()) {
            return "((" + this.getClazz().getName().replace('$', '.') + ")" + OBJECT_VAR_NAME + ")." + property.getSetMethod().getName() + "(" + property.getConversion(VALUE_VAR_NAME) + ");";
        }
        return null;
    }

    public String generateGetPropertyMethod(ReflectionProperty property) {
        if (property.hasGetPropertyGetter()) {
            return "result = ((" + this.getClazz().getName().replace('$', '.') + ")" + OBJECT_VAR_NAME + ")." + property.getGetMethod().getName() + "(" + NAME_VAR_NAME + ");";
        }
        if (property.hasGetter()) {
            return "result = ((" + this.getClazz().getName().replace('$', '.') + ")" + OBJECT_VAR_NAME + ")." + property.getGetMethod().getName() + "();";
        }
        return null;
    }

    public String generateSetPropertyForMethod() {
        StringBuilder code = new StringBuilder(ReflectionLessCodeGenerator.getIndent(1)).append(this.generatesSetPropertyForMethodHeader()).append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("switch (").append(NAME_VAR_NAME).append(") {").append(System.lineSeparator());
        for (ReflectionProperty property : this.getProperties()) {
            String invocation = this.generateSetPropertyMethod(property);
            if (invocation != null) {
                code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append("case \"").append(property.getPropertyName()).append("\" : ").append(System.lineSeparator());
                code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(4)).append(invocation).append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(4)).append("return true;").append(System.lineSeparator());
                continue;
            }
            code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append("//no set" + IntrospectionUtils.capitalize(property.getPropertyName()) + " method found on this class").append(System.lineSeparator());
        }
        code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("}").append(System.lineSeparator());
        if (this.getGenericSetPropertyMethod() != null) {
            ReflectionProperty p = new ReflectionProperty(this.clazz.getName(), "property", String.class, this.getGenericSetPropertyMethod(), null);
            code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("if (").append(SETP_VAR_NAME).append(") {").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append(this.generateSetPropertyMethod(p)).append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append("return true;").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("}").append(System.lineSeparator());
        }
        code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("return ").append(this.getSetPropertyForExitStatement()).append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(1)).append("}");
        return code.toString();
    }

    private String getSetPropertyForExitStatement() {
        return this.getParent() != null ? this.getParent().generateParentSetPropertyForMethodInvocation() : (this.getGenericSetPropertyMethod() != null ? "true;" : "false;");
    }

    public String generateInvocationSetForPropertyCaseStatement(int level) {
        StringBuilder code = new StringBuilder(ReflectionLessCodeGenerator.getIndent(level)).append("case \"").append(this.getClazz().getName()).append("\" : ").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(level + 1)).append("return ").append(this.generateParentSetPropertyForMethodInvocation()).append(System.lineSeparator());
        return code.toString();
    }

    public String generateParentSetPropertyForMethodInvocation() {
        String[] classParts = this.clazz.getName().split("\\.|\\$");
        StringBuilder methodInvocation = new StringBuilder("setPropertyFor");
        for (String s : classParts) {
            methodInvocation.append(IntrospectionUtils.capitalize(s));
        }
        methodInvocation.append("(").append(OBJECT_VAR_NAME).append(", ").append(NAME_VAR_NAME).append(", ").append(VALUE_VAR_NAME).append(", ").append(SETP_VAR_NAME).append(");");
        return methodInvocation.toString();
    }

    public String generatesSetPropertyForMethodHeader() {
        String[] classParts = this.clazz.getName().split("\\.|\\$");
        StringBuilder methodInvocation = new StringBuilder("private static boolean setPropertyFor");
        for (String s : classParts) {
            methodInvocation.append(IntrospectionUtils.capitalize(s));
        }
        methodInvocation.append("(Object ").append(OBJECT_VAR_NAME).append(", String ").append(NAME_VAR_NAME).append(", String ").append(VALUE_VAR_NAME).append(", boolean ").append(SETP_VAR_NAME).append(") {");
        return methodInvocation.toString();
    }

    public String generateInvocationGetForPropertyCaseStatement(int level) {
        StringBuilder code = new StringBuilder(ReflectionLessCodeGenerator.getIndent(level)).append("case \"").append(this.getClazz().getName()).append("\" : ").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(level + 1)).append("result = ").append(this.generateParentGetPropertyForMethodInvocation()).append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(level + 1)).append("break;").append(System.lineSeparator());
        return code.toString();
    }

    public String generateParentGetPropertyForMethodInvocation() {
        String[] classParts = this.clazz.getName().split("\\.|\\$");
        StringBuilder methodInvocation = new StringBuilder("getPropertyFor");
        for (String s : classParts) {
            methodInvocation.append(IntrospectionUtils.capitalize(s));
        }
        methodInvocation.append("(").append(OBJECT_VAR_NAME).append(", ").append(NAME_VAR_NAME).append(");");
        return methodInvocation.toString();
    }

    public String generatesGetPropertyForMethodHeader() {
        String[] classParts = this.clazz.getName().split("\\.|\\$");
        StringBuilder methodInvocation = new StringBuilder("private static Object getPropertyFor");
        for (String s : classParts) {
            methodInvocation.append(IntrospectionUtils.capitalize(s));
        }
        methodInvocation.append("(Object ").append(OBJECT_VAR_NAME).append(", String ").append(NAME_VAR_NAME).append(") {");
        return methodInvocation.toString();
    }

    private String getGetPropertyForExitStatement() {
        if (this.getParent() != null) {
            return this.getParent().generateParentGetPropertyForMethodInvocation();
        }
        return "null;";
    }

    public String generateGetPropertyForMethod() {
        StringBuilder code = new StringBuilder(ReflectionLessCodeGenerator.getIndent(1)).append(this.generatesGetPropertyForMethodHeader()).append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("Object result = null;").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("switch (").append(NAME_VAR_NAME).append(") {").append(System.lineSeparator());
        for (ReflectionProperty property : this.getProperties()) {
            String invocation = this.generateGetPropertyMethod(property);
            if (invocation != null) {
                code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append("case \"").append(property.getPropertyName()).append("\" : ").append(System.lineSeparator());
                code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(4)).append(invocation).append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(4)).append("break;").append(System.lineSeparator());
                continue;
            }
            code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append("//no get" + IntrospectionUtils.capitalize(property.getPropertyName()) + " method found on this class").append(System.lineSeparator());
        }
        code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("}").append(System.lineSeparator());
        code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("if (result == null) {").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append("result = ").append(this.getGetPropertyForExitStatement()).append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("}").append(System.lineSeparator());
        if (this.getGenericGetPropertyMethod() != null) {
            ReflectionProperty p = new ReflectionProperty(this.clazz.getName(), "property", String.class, null, this.getGenericGetPropertyMethod());
            code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("if (result == null) {").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append(this.generateGetPropertyMethod(p)).append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("}").append(System.lineSeparator());
        }
        code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("return result;").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(1)).append("}").append(System.lineSeparator());
        return code.toString();
    }

    @Override
    public int compareTo(SetPropertyClass o) {
        return this.clazz.getName().compareTo(o.clazz.getName());
    }
}

