/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.cert.crmf;

import com.icbc.bcpkix.org.bouncycastle.cert.crmf.CRMFException;
import com.icbc.bcpkix.org.bouncycastle.cert.crmf.PKMACBuilder;
import com.icbc.bcpkix.org.bouncycastle.operator.MacCalculator;
import com.icbc.bcprov.org.bouncycastle.asn1.cmp.PBMParameter;
import com.icbc.bcprov.org.bouncycastle.asn1.crmf.PKMACValue;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public boolean isValid(PKMACValue pKMACValue, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(pKMACValue.getAlgId().getParameters()));
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return Arrays.constantTimeAreEqual(macCalculator.getMac(), pKMACValue.getValue().getBytes());
    }
}

