/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.pkcs.jcajce;

import com.icbc.bcpkix.org.bouncycastle.operator.DefaultSecretKeySizeProvider;
import com.icbc.bcpkix.org.bouncycastle.operator.InputDecryptor;
import com.icbc.bcpkix.org.bouncycastle.operator.InputDecryptorProvider;
import com.icbc.bcpkix.org.bouncycastle.operator.OperatorCreationException;
import com.icbc.bcpkix.org.bouncycastle.operator.SecretKeySizeProvider;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Object;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1OctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import com.icbc.bcprov.org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.misc.ScryptParams;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PBEParameter;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PBES2Parameters;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.crypto.PasswordConverter;
import com.icbc.bcprov.org.bouncycastle.jcajce.PBKDF1Key;
import com.icbc.bcprov.org.bouncycastle.jcajce.PKCS12KeyWithParameters;
import com.icbc.bcprov.org.bouncycastle.jcajce.io.CipherInputStream;
import com.icbc.bcprov.org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import com.icbc.bcprov.org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import com.icbc.bcprov.org.bouncycastle.jcajce.spec.ScryptKeySpec;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.JcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class JcePKCSPBEInputDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private boolean wrongPKCS12Zero = false;
    private SecretKeySizeProvider keySizeProvider = DefaultSecretKeySizeProvider.INSTANCE;

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setTryWrongPKCS12Zero(boolean bl) {
        this.wrongPKCS12Zero = bl;
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setKeySizeProvider(SecretKeySizeProvider secretKeySizeProvider) {
        this.keySizeProvider = secretKeySizeProvider;
        return this;
    }

    public InputDecryptorProvider build(final char[] cArray) {
        return new InputDecryptorProvider(){
            private Cipher cipher;
            private AlgorithmIdentifier encryptionAlg;

            @Override
            public InputDecryptor get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                block9: {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
                    try {
                        if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(aSN1ObjectIdentifier.getId());
                            this.cipher.init(2, new PKCS12KeyWithParameters(cArray, JcePKCSPBEInputDecryptorProviderBuilder.this.wrongPKCS12Zero, pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue()));
                            this.encryptionAlg = algorithmIdentifier;
                            break block9;
                        }
                        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
                            SecretKey secretKey;
                            ASN1Object aSN1Object;
                            Object object;
                            PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
                            if (MiscObjectIdentifiers.id_scrypt.equals(pBES2Parameters.getKeyDerivationFunc().getAlgorithm())) {
                                object = ScryptParams.getInstance(pBES2Parameters.getKeyDerivationFunc().getParameters());
                                aSN1Object = AlgorithmIdentifier.getInstance(pBES2Parameters.getEncryptionScheme());
                                SecretKeyFactory secretKeyFactory = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createSecretKeyFactory("SCRYPT");
                                secretKey = secretKeyFactory.generateSecret(new ScryptKeySpec(cArray, ((ScryptParams)object).getSalt(), ((ScryptParams)object).getCostParameter().intValue(), ((ScryptParams)object).getBlockSize().intValue(), ((ScryptParams)object).getParallelizationParameter().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize((AlgorithmIdentifier)aSN1Object)));
                            } else {
                                object = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createSecretKeyFactory(pBES2Parameters.getKeyDerivationFunc().getAlgorithm().getId());
                                aSN1Object = PBKDF2Params.getInstance(pBES2Parameters.getKeyDerivationFunc().getParameters());
                                AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance(pBES2Parameters.getEncryptionScheme());
                                secretKey = ((PBKDF2Params)aSN1Object).isDefaultPrf() ? ((SecretKeyFactory)object).generateSecret(new PBEKeySpec(cArray, ((PBKDF2Params)aSN1Object).getSalt(), ((PBKDF2Params)aSN1Object).getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(algorithmIdentifier2))) : ((SecretKeyFactory)object).generateSecret(new PBKDF2KeySpec(cArray, ((PBKDF2Params)aSN1Object).getSalt(), ((PBKDF2Params)aSN1Object).getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(algorithmIdentifier2), ((PBKDF2Params)aSN1Object).getPrf()));
                            }
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(pBES2Parameters.getEncryptionScheme().getAlgorithm().getId());
                            this.encryptionAlg = AlgorithmIdentifier.getInstance(pBES2Parameters.getEncryptionScheme());
                            object = pBES2Parameters.getEncryptionScheme().getParameters();
                            if (object instanceof ASN1OctetString) {
                                this.cipher.init(2, (Key)secretKey, new IvParameterSpec(ASN1OctetString.getInstance(object).getOctets()));
                            } else {
                                aSN1Object = GOST28147Parameters.getInstance(object);
                                this.cipher.init(2, (Key)secretKey, new GOST28147ParameterSpec(((GOST28147Parameters)aSN1Object).getEncryptionParamSet(), ((GOST28147Parameters)aSN1Object).getIV()));
                            }
                            break block9;
                        }
                        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC) || aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC)) {
                            PBEParameter pBEParameter = PBEParameter.getInstance(algorithmIdentifier.getParameters());
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(aSN1ObjectIdentifier.getId());
                            this.cipher.init(2, (Key)new PBKDF1Key(cArray, PasswordConverter.ASCII), new PBEParameterSpec(pBEParameter.getSalt(), pBEParameter.getIterationCount().intValue()));
                            break block9;
                        }
                        throw new OperatorCreationException("unable to create InputDecryptor: algorithm " + aSN1ObjectIdentifier + " unknown.");
                    }
                    catch (Exception exception) {
                        throw new OperatorCreationException("unable to create InputDecryptor: " + exception.getMessage(), exception);
                    }
                }
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return encryptionAlg;
                    }

                    @Override
                    public InputStream getInputStream(InputStream inputStream) {
                        return new CipherInputStream(inputStream, cipher);
                    }
                };
            }
        };
    }
}

