/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.qtesla;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.NullDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.qtesla.QTESLASigner;
import com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPrivateKey;
import com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPublicKey;
import com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.qtesla.DigestUtil;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends Signature {
    private Digest digest;
    private QTESLASigner signer;
    private SecureRandom random;

    protected SignatureSpi(String string) {
        super(string);
    }

    protected SignatureSpi(String string, Digest digest, QTESLASigner qTESLASigner) {
        super(string);
        this.digest = digest;
        this.signer = qTESLASigner;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCqTESLAPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to qTESLA");
        }
        CipherParameters cipherParameters = ((BCqTESLAPublicKey)publicKey).getKeyParams();
        this.digest.reset();
        this.signer.init(false, cipherParameters);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters cipherParameters;
        if (privateKey instanceof BCqTESLAPrivateKey) {
            cipherParameters = ((BCqTESLAPrivateKey)privateKey).getKeyParams();
            if (this.random != null) {
                cipherParameters = new ParametersWithRandom(cipherParameters, this.random);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to qTESLA");
        }
        this.signer.init(true, cipherParameters);
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.digest.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.digest.update(byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = DigestUtil.getDigestResult(this.digest);
            return this.signer.generateSignature(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof IllegalStateException) {
                throw new SignatureException(exception.getMessage());
            }
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = DigestUtil.getDigestResult(this.digest);
        return this.signer.verifySignature(byArray2, byArray);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class ProvablySecureIII
    extends SignatureSpi {
        public ProvablySecureIII() {
            super(QTESLASecurityCategory.getName(4), new NullDigest(), new QTESLASigner());
        }
    }

    public static class ProvablySecureI
    extends SignatureSpi {
        public ProvablySecureI() {
            super(QTESLASecurityCategory.getName(3), new NullDigest(), new QTESLASigner());
        }
    }

    public static class HeuristicIIISpeed
    extends SignatureSpi {
        public HeuristicIIISpeed() {
            super(QTESLASecurityCategory.getName(2), new NullDigest(), new QTESLASigner());
        }
    }

    public static class HeuristicIIISize
    extends SignatureSpi {
        public HeuristicIIISize() {
            super(QTESLASecurityCategory.getName(1), new NullDigest(), new QTESLASigner());
        }
    }

    public static class HeuristicI
    extends SignatureSpi {
        public HeuristicI() {
            super(QTESLASecurityCategory.getName(0), new NullDigest(), new QTESLASigner());
        }
    }

    public static class qTESLA
    extends SignatureSpi {
        public qTESLA() {
            super("qTESLA", new NullDigest(), new QTESLASigner());
        }
    }
}

