/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.apiLib;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import com.icbc.bcprov.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.basic.MessageDigest;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import com.icbc.hsm.utils.encoders.Hex;
import java.io.InputStream;

public class Hash {
    public static final String API_NAME = "hash";
    private String hashAlgorithm;

    private Hash(String string) {
        this.hashAlgorithm = string;
    }

    public static Hash getInstance(String string) {
        Hash hash = new Hash(string);
        return hash;
    }

    public byte[] GenerateHash(byte[] byArray) throws Exception {
        String string = this.hashAlgorithm;
        byte[] byArray2 = MessageDigest.digest(string, byArray);
        return byArray2;
    }

    public byte[] GenerateHash(InputStream inputStream) throws Exception {
        String string = this.hashAlgorithm;
        byte[] byArray = MessageDigest.streamDigest(string, inputStream);
        return byArray;
    }

    public byte[] GenerateHash(byte[] byArray, byte[] byArray2, String string) throws Exception {
        String string2 = this.hashAlgorithm;
        byte[] byArray3 = null;
        String string3 = null;
        String string4 = null;
        string3 = byArray2 == null ? "31323334353637383132333435363738" : Hex.toHexString(byArray2);
        if (string.length() != 130 || !string.startsWith("04")) {
            throw new Exception("key data error");
        }
        string4 = string.substring(2);
        String string5 = "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC";
        String string6 = "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93";
        String string7 = "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7";
        String string8 = "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0";
        String string9 = string3 + string5 + string6 + string7 + string8 + string4;
        String string10 = String.format("%1$04x", string3.length() * 4);
        string9 = string10 + string9;
        byArray3 = MessageDigest.digest(string2, Hex.decode(string9));
        byte[] byArray4 = new byte[byArray3.length + byArray.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        byArray3 = MessageDigest.digest(string2, byArray4);
        return byArray3;
    }

    public byte[] GenerateHash(byte[] byArray, byte[] byArray2, HsmKeyParameter hsmKeyParameter) throws Exception {
        ECPoint eCPoint;
        ECPrivateKeyParameters eCPrivateKeyParameters;
        CipherParameters cipherParameters;
        ClearKeyParameter clearKeyParameter;
        String string = null;
        if (hsmKeyParameter instanceof ClearKeyParameter) {
            clearKeyParameter = (ClearKeyParameter)hsmKeyParameter;
            if ("SM2private".equalsIgnoreCase(clearKeyParameter.getKeyType())) {
                cipherParameters = clearKeyParameter.getBCkey();
                if (cipherParameters instanceof ECPrivateKeyParameters) {
                    eCPrivateKeyParameters = (ECPrivateKeyParameters)cipherParameters;
                    eCPoint = new FixedPointCombMultiplier().multiply(eCPrivateKeyParameters.getParameters().getG(), eCPrivateKeyParameters.getD()).normalize();
                    string = "04" + String.format("%1$064x", eCPoint.getAffineXCoord().toBigInteger()) + String.format("%1$064x", eCPoint.getAffineYCoord().toBigInteger());
                }
            } else if ("SM2public".equalsIgnoreCase(clearKeyParameter.getKeyType())) {
                string = clearKeyParameter.getPublicKey();
            }
        }
        if (IcbcEnvironment.isICBCEnvironment() && hsmKeyParameter instanceof IcbcAsymmetricKeyParameter) {
            clearKeyParameter = (IcbcAsymmetricKeyParameter)hsmKeyParameter;
            if ("SM2private".equalsIgnoreCase(clearKeyParameter.getKeyType())) {
                cipherParameters = clearKeyParameter.getBCkey();
                if (cipherParameters instanceof ECPrivateKeyParameters) {
                    eCPrivateKeyParameters = (ECPrivateKeyParameters)cipherParameters;
                    eCPoint = new FixedPointCombMultiplier().multiply(eCPrivateKeyParameters.getParameters().getG(), eCPrivateKeyParameters.getD()).normalize();
                    string = "04" + String.format("%1$064x", eCPoint.getAffineXCoord().toBigInteger()) + String.format("%1$064x", eCPoint.getAffineYCoord().toBigInteger());
                }
            } else if ("SM2public".equalsIgnoreCase(clearKeyParameter.getKeyType())) {
                string = clearKeyParameter.getPublicKey();
            }
        }
        if (string != null) {
            return this.GenerateHash(byArray, byArray2, string);
        }
        throw new Exception("key type error!");
    }

    public String getParameter() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("hashAlgorithm: ").append(this.hashAlgorithm);
        return stringBuffer.toString();
    }
}

