/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.crypto.BlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.Mac;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.AESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.DESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.SM4Engine;
import com.icbc.bcprov.org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import com.icbc.bcprov.org.bouncycastle.crypto.macs.ISO9797Alg3Mac;
import com.icbc.bcprov.org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithIV;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.utils.Helper;
import java.io.InputStream;

public class MessageAuthenticate {
    private MessageAuthenticate() {
    }

    public static byte[] authenticate(String string, String string2, CipherParameters cipherParameters, byte[] byArray, byte[] byArray2) throws Exception {
        CipherParameters cipherParameters2 = Helper.toBCkey(cipherParameters);
        Mac mac = null;
        ISO7816d4Padding iSO7816d4Padding = null;
        if ("X9.19".equalsIgnoreCase(string2)) {
            iSO7816d4Padding = null;
        } else if ("zeroPadding".equalsIgnoreCase(string2)) {
            iSO7816d4Padding = null;
        } else if ("EMV".equalsIgnoreCase(string2)) {
            iSO7816d4Padding = new ISO7816d4Padding();
        } else if ("PBOC".equalsIgnoreCase(string2)) {
            iSO7816d4Padding = new ISO7816d4Padding();
        } else if ("ISO7816d4Padding".equalsIgnoreCase(string2)) {
            iSO7816d4Padding = new ISO7816d4Padding();
        } else {
            throw new ParmErrorException("MAC Cipher Padding Name error:" + string2);
        }
        BlockCipher blockCipher = null;
        if ("AES".equalsIgnoreCase(string)) {
            blockCipher = new AESEngine();
            mac = new CBCBlockCipherMac(blockCipher, blockCipher.getBlockSize() * 8, iSO7816d4Padding);
        } else if ("DES".equalsIgnoreCase(string)) {
            blockCipher = new DESEngine();
            mac = new CBCBlockCipherMac(blockCipher, blockCipher.getBlockSize() * 8, iSO7816d4Padding);
        } else if ("DESede".equalsIgnoreCase(string)) {
            blockCipher = new DESEngine();
            mac = new ISO9797Alg3Mac(blockCipher, blockCipher.getBlockSize() * 8, iSO7816d4Padding);
        } else if ("SM4".equalsIgnoreCase(string)) {
            blockCipher = new SM4Engine();
            mac = new CBCBlockCipherMac(blockCipher, blockCipher.getBlockSize() * 8, iSO7816d4Padding);
        } else {
            throw new ParmErrorException("MAC Cipher Algorithm Name error:" + string);
        }
        CipherParameters cipherParameters3 = null;
        if (byArray == null) {
            cipherParameters3 = cipherParameters2;
        } else if (byArray.length == blockCipher.getBlockSize()) {
            cipherParameters3 = new ParametersWithIV(cipherParameters2, byArray);
        } else {
            throw new ParmErrorException("initialisation vector must be the same length as cipher block size");
        }
        mac.init(cipherParameters3);
        try {
            mac.update(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            mac.reset();
            throw exception;
        }
        byte[] byArray3 = new byte[blockCipher.getBlockSize()];
        mac.doFinal(byArray3, 0);
        mac.reset();
        return byArray3;
    }

    public static byte[] streamAuthenticate(String string, String string2, CipherParameters cipherParameters, byte[] byArray, InputStream inputStream) throws Exception {
        CipherParameters cipherParameters2 = Helper.toBCkey(cipherParameters);
        Mac mac = null;
        ISO7816d4Padding iSO7816d4Padding = null;
        if ("X9.19".equalsIgnoreCase(string2)) {
            iSO7816d4Padding = null;
        } else if ("zeroPadding".equalsIgnoreCase(string2)) {
            iSO7816d4Padding = null;
        } else if ("EMV".equalsIgnoreCase(string2)) {
            iSO7816d4Padding = new ISO7816d4Padding();
        } else if ("PBOC".equalsIgnoreCase(string2)) {
            iSO7816d4Padding = new ISO7816d4Padding();
        } else if ("ISO7816d4Padding".equalsIgnoreCase(string2)) {
            iSO7816d4Padding = new ISO7816d4Padding();
        } else {
            throw new ParmErrorException("MAC Cipher Padding Name error:" + string2);
        }
        BlockCipher blockCipher = null;
        if ("AES".equalsIgnoreCase(string)) {
            blockCipher = new AESEngine();
            mac = new CBCBlockCipherMac(blockCipher, blockCipher.getBlockSize() * 8, iSO7816d4Padding);
        } else if ("DES".equalsIgnoreCase(string)) {
            blockCipher = new DESEngine();
            mac = new CBCBlockCipherMac(blockCipher, blockCipher.getBlockSize() * 8, iSO7816d4Padding);
        } else if ("DESede".equalsIgnoreCase(string)) {
            blockCipher = new DESEngine();
            mac = new ISO9797Alg3Mac(blockCipher, blockCipher.getBlockSize() * 8, iSO7816d4Padding);
        } else if ("SM4".equalsIgnoreCase(string)) {
            blockCipher = new SM4Engine();
            mac = new CBCBlockCipherMac(blockCipher, blockCipher.getBlockSize() * 8, iSO7816d4Padding);
        } else {
            throw new ParmErrorException("MAC Cipher Algorithm Name error:" + string);
        }
        CipherParameters cipherParameters3 = null;
        if (byArray == null) {
            cipherParameters3 = cipherParameters2;
        } else if (byArray.length == blockCipher.getBlockSize()) {
            cipherParameters3 = new ParametersWithIV(cipherParameters2, byArray);
        } else {
            throw new ParmErrorException("initialisation vector must be the same length as cipher block size");
        }
        mac.init(cipherParameters3);
        Long l = new Long(0L);
        int n = 4096;
        byte[] byArray2 = new byte[n];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray2, 0, n)) > 0) {
                mac.update(byArray2, 0, n2);
                l = l + (long)n2;
            }
        }
        catch (Exception exception) {
            mac.reset();
            throw exception;
        }
        byte[] byArray3 = new byte[blockCipher.getBlockSize()];
        mac.doFinal(byArray3, 0);
        mac.reset();
        return byArray3;
    }
}

