/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.crypto.ExtendedDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.PBEParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.MD5Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA1Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA224Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA256Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA384Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA512Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SM3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.params.KeyParameter;
import com.icbc.hsm.software.exception.ParmErrorException;

public class PBEkeyGenerate {
    private PBEkeyGenerate() {
    }

    public static byte[] generatePBEKey(String string, String string2, String string3, int n, byte[] byArray, byte[] byArray2, int n2) throws Exception {
        ExtendedDigest extendedDigest = null;
        if ("MD5".equalsIgnoreCase(string2)) {
            extendedDigest = new MD5Digest();
        } else if ("SHA1".equalsIgnoreCase(string2)) {
            extendedDigest = new SHA1Digest();
        } else if ("SHA224".equalsIgnoreCase(string2)) {
            extendedDigest = new SHA224Digest();
        } else if ("SHA256".equalsIgnoreCase(string2)) {
            extendedDigest = new SHA256Digest();
        } else if ("SHA384".equalsIgnoreCase(string2)) {
            extendedDigest = new SHA384Digest();
        } else if ("SHA512".equalsIgnoreCase(string2)) {
            extendedDigest = new SHA512Digest();
        } else if (string2 != null && string2.startsWith("SHA3-")) {
            int n3 = Integer.parseInt(string2.substring("SHA3-".length()));
            extendedDigest = new SHA3Digest(n3);
        } else if ("SM3".equalsIgnoreCase(string2)) {
            extendedDigest = new SM3Digest();
        } else {
            throw new ParmErrorException("Digest Algorithm Name error:" + string2);
        }
        if (n <= 0) {
            throw new ParmErrorException("keySize error:" + n);
        }
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = null;
        if (!"PBKDF2".equalsIgnoreCase(string)) {
            throw new ParmErrorException("PBE Algorithm Name error:" + string);
        }
        pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(extendedDigest);
        pKCS5S2ParametersGenerator.init(byArray, byArray2, n2);
        KeyParameter keyParameter = null;
        keyParameter = "MAC".equalsIgnoreCase(string3) ? (KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedMacParameters(n * 8) : (KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(n * 8);
        byte[] byArray3 = keyParameter.getKey();
        return byArray3;
    }
}

