/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Integer;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSequence;
import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.ExtendedDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.EncodableDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.MD5Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.NullDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA1Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA224Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA256Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA384Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA512Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SM3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.RSAEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithID;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.signers.PSSSigner;
import com.icbc.bcprov.org.bouncycastle.crypto.signers.RSADigestSigner;
import com.icbc.bcprov.org.bouncycastle.crypto.signers.SM2Signer;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import com.icbc.hsm.software.utils.Helper;
import com.icbc.hsm.utils.encoders.Hex;
import java.io.IOException;
import java.math.BigInteger;

public class Signature {
    private Signature() {
    }

    public static byte[] sign(String string, CipherParameters cipherParameters, byte[] byArray) throws Exception {
        CipherParameters cipherParameters2 = Helper.toBCkey(cipherParameters);
        if ("SM3WITHSM2".equalsIgnoreCase(string)) {
            byte[] byArray2;
            if (IcbcEnvironment.isICBCEnvironment() && cipherParameters instanceof IcbcAsymmetricKeyParameter && (byArray2 = ((IcbcAsymmetricKeyParameter)cipherParameters).getId()) != null) {
                cipherParameters2 = new ParametersWithID(cipherParameters2, byArray2);
            }
            if (!IcbcEnvironment.isICBCEnvironment() && cipherParameters instanceof ClearKeyParameter && (byArray2 = ((ClearKeyParameter)cipherParameters).getId()) != null) {
                cipherParameters2 = new ParametersWithID(cipherParameters2, byArray2);
            }
            return Signature.sm2Sign(cipherParameters2, byArray, true);
        }
        if ("NONEWITHSM2".equalsIgnoreCase(string)) {
            return Signature.sm2Sign(cipherParameters2, byArray, false);
        }
        if ("PS256".equalsIgnoreCase(string) || "PS384".equalsIgnoreCase(string) || "PS512".equalsIgnoreCase(string)) {
            if (!(cipherParameters2 instanceof RSAKeyParameters)) {
                // empty if block
            }
            return Signature.pssSign(string, cipherParameters2, byArray);
        }
        if (string != null && string.toUpperCase().endsWith("WITHRSA")) {
            if (!(cipherParameters2 instanceof RSAKeyParameters)) {
                // empty if block
            }
            return Signature.rsaSign(string, cipherParameters2, byArray);
        }
        throw new ParmErrorException("signature Algorithm Name error:" + string);
    }

    public static boolean verify(String string, CipherParameters cipherParameters, byte[] byArray, byte[] byArray2) throws Exception {
        CipherParameters cipherParameters2 = Helper.toBCkey(cipherParameters);
        if ("SM3WITHSM2".equalsIgnoreCase(string)) {
            byte[] byArray3;
            if (IcbcEnvironment.isICBCEnvironment() && cipherParameters instanceof IcbcAsymmetricKeyParameter && (byArray3 = ((IcbcAsymmetricKeyParameter)cipherParameters).getId()) != null) {
                cipherParameters2 = new ParametersWithID(cipherParameters2, byArray3);
            }
            if (!IcbcEnvironment.isICBCEnvironment() && cipherParameters instanceof ClearKeyParameter && (byArray3 = ((ClearKeyParameter)cipherParameters).getId()) != null) {
                cipherParameters2 = new ParametersWithID(cipherParameters2, byArray3);
            }
            return Signature.sm2Verify(cipherParameters2, byArray, byArray2, true);
        }
        if ("NONEWITHSM2".equalsIgnoreCase(string)) {
            return Signature.sm2Verify(cipherParameters2, byArray, byArray2, false);
        }
        if ("PS256".equalsIgnoreCase(string) || "PS384".equalsIgnoreCase(string) || "PS512".equalsIgnoreCase(string)) {
            if (!(cipherParameters2 instanceof RSAKeyParameters)) {
                // empty if block
            }
            return Signature.pssVerify(string, cipherParameters2, byArray, byArray2);
        }
        if (string != null && string.toUpperCase().endsWith("WITHRSA")) {
            if (!(cipherParameters2 instanceof RSAKeyParameters)) {
                // empty if block
            }
            return Signature.rsaVerify(string, cipherParameters2, byArray, byArray2);
        }
        throw new ParmErrorException("signature Algorithm Name error:" + string);
    }

    private static byte[] rsaSign(String string, CipherParameters cipherParameters, byte[] byArray) throws Exception {
        ExtendedDigest extendedDigest = null;
        if (string == null) {
            throw new ParmErrorException("signature Algorithm Name error:" + string);
        }
        if (string.toUpperCase().startsWith("MD5")) {
            extendedDigest = new MD5Digest();
        } else if (string.toUpperCase().startsWith("SHA1")) {
            extendedDigest = new SHA1Digest();
        } else if (string.toUpperCase().startsWith("SHA224")) {
            extendedDigest = new SHA224Digest();
        } else if (string.toUpperCase().startsWith("SHA256")) {
            extendedDigest = new SHA256Digest();
        } else if (string.toUpperCase().startsWith("SHA384")) {
            extendedDigest = new SHA384Digest();
        } else if (string.toUpperCase().startsWith("SHA512")) {
            extendedDigest = new SHA512Digest();
        } else if (string.toUpperCase().startsWith("SHA3-")) {
            int n = Integer.parseInt(string.substring("SHA3-".length(), 3));
            extendedDigest = new SHA3Digest(n);
        } else if (string.toUpperCase().startsWith("SM3")) {
            extendedDigest = new SM3Digest();
        } else {
            throw new ParmErrorException("signature Algorithm Name error:" + string);
        }
        RSADigestSigner rSADigestSigner = null;
        rSADigestSigner = new RSADigestSigner(extendedDigest);
        rSADigestSigner.init(true, cipherParameters);
        rSADigestSigner.update(byArray, 0, byArray.length);
        byte[] byArray2 = rSADigestSigner.generateSignature();
        return byArray2;
    }

    private static boolean rsaVerify(String string, CipherParameters cipherParameters, byte[] byArray, byte[] byArray2) throws Exception {
        ExtendedDigest extendedDigest = null;
        if (string == null) {
            throw new ParmErrorException("signature Algorithm Name error:" + string);
        }
        if (string.toUpperCase().startsWith("MD5")) {
            extendedDigest = new MD5Digest();
        } else if (string.toUpperCase().startsWith("SHA1")) {
            extendedDigest = new SHA1Digest();
        } else if (string.toUpperCase().startsWith("SHA224")) {
            extendedDigest = new SHA224Digest();
        } else if (string.toUpperCase().startsWith("SHA256")) {
            extendedDigest = new SHA256Digest();
        } else if (string.toUpperCase().startsWith("SHA384")) {
            extendedDigest = new SHA384Digest();
        } else if (string.toUpperCase().startsWith("SHA512")) {
            extendedDigest = new SHA512Digest();
        } else if (string.toUpperCase().startsWith("SHA3-")) {
            int n = Integer.parseInt(string.substring("SHA3-".length(), 3));
            extendedDigest = new SHA3Digest(n);
        } else if (string.toUpperCase().startsWith("SM3")) {
            extendedDigest = new SM3Digest();
        } else {
            throw new ParmErrorException("signature Algorithm Name error:" + string);
        }
        RSADigestSigner rSADigestSigner = null;
        rSADigestSigner = new RSADigestSigner(extendedDigest);
        rSADigestSigner.init(false, cipherParameters);
        rSADigestSigner.update(byArray, 0, byArray.length);
        boolean bl = rSADigestSigner.verifySignature(byArray2);
        return bl;
    }

    private static byte[] pssSign(String string, CipherParameters cipherParameters, byte[] byArray) throws Exception {
        Object object;
        PSSSigner pSSSigner = null;
        RSAEngine rSAEngine = new RSAEngine();
        if ("PS256".equalsIgnoreCase(string)) {
            object = new SHA256Digest();
            pSSSigner = new PSSSigner((AsymmetricBlockCipher)rSAEngine, (Digest)object, 32);
        } else if ("PS384".equalsIgnoreCase(string)) {
            object = new SHA384Digest();
            pSSSigner = new PSSSigner((AsymmetricBlockCipher)rSAEngine, (Digest)object, 32);
        } else if ("PS512".equalsIgnoreCase(string)) {
            object = new SHA512Digest();
            pSSSigner = new PSSSigner((AsymmetricBlockCipher)rSAEngine, (Digest)object, 32);
        } else {
            throw new ParmErrorException("signature Algorithm Name error:" + string);
        }
        pSSSigner.init(true, cipherParameters);
        pSSSigner.update(byArray, 0, byArray.length);
        object = null;
        object = pSSSigner.generateSignature();
        return object;
    }

    private static boolean pssVerify(String string, CipherParameters cipherParameters, byte[] byArray, byte[] byArray2) throws Exception {
        EncodableDigest encodableDigest;
        PSSSigner pSSSigner = null;
        RSAEngine rSAEngine = new RSAEngine();
        if ("PS256".equalsIgnoreCase(string)) {
            encodableDigest = new SHA256Digest();
            pSSSigner = new PSSSigner((AsymmetricBlockCipher)rSAEngine, (Digest)((Object)encodableDigest), 32);
        } else if ("PS384".equalsIgnoreCase(string)) {
            encodableDigest = new SHA384Digest();
            pSSSigner = new PSSSigner((AsymmetricBlockCipher)rSAEngine, (Digest)((Object)encodableDigest), 32);
        } else if ("PS512".equalsIgnoreCase(string)) {
            encodableDigest = new SHA512Digest();
            pSSSigner = new PSSSigner((AsymmetricBlockCipher)rSAEngine, (Digest)((Object)encodableDigest), 32);
        } else {
            throw new ParmErrorException("signature Algorithm Name error:" + string);
        }
        pSSSigner.init(true, cipherParameters);
        pSSSigner.update(byArray, 0, byArray.length);
        boolean bl = pSSSigner.verifySignature(byArray2);
        return bl;
    }

    private static byte[] sm2Sign(CipherParameters cipherParameters, byte[] byArray, boolean bl) throws Exception {
        byte[] byArray2 = byArray;
        byte[] byArray3 = null;
        SM2Signer sM2Signer = null;
        NullDigest nullDigest = new NullDigest();
        sM2Signer = bl ? new SM2Signer() : new SM2Signer(nullDigest);
        do {
            sM2Signer.reset();
            sM2Signer.init(true, cipherParameters);
            if (!bl) {
                nullDigest.reset();
            }
            sM2Signer.update(byArray2, 0, byArray2.length);
            byArray3 = sM2Signer.generateSignature();
            if (Signature.validateASN1(byArray3)) continue;
            System.out.println("improper signature:" + Hex.toHexString(byArray3) + " regenerate!");
        } while (!Signature.validateASN1(byArray3));
        return byArray3;
    }

    private static boolean sm2Verify(CipherParameters cipherParameters, byte[] byArray, byte[] byArray2, boolean bl) {
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        boolean bl2 = false;
        try {
            SM2Signer sM2Signer = null;
            NullDigest nullDigest = new NullDigest();
            sM2Signer = bl ? new SM2Signer() : new SM2Signer(nullDigest);
            sM2Signer.init(false, cipherParameters);
            if (!bl) {
                nullDigest.reset();
            }
            sM2Signer.update(byArray3, 0, byArray3.length);
            bl2 = sM2Signer.verifySignature(byArray4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl2;
    }

    private static boolean validateASN1(byte[] byArray) {
        boolean bl = true;
        ASN1Sequence aSN1Sequence = null;
        if (byArray == null) {
            return false;
        }
        try {
            aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        if (aSN1Sequence.size() == 2) {
            byte[] byArray2;
            byte[] byArray3 = ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue().toByteArray();
            if (byArray3.length < 32) {
                bl = false;
            }
            if ((byArray2 = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue().toByteArray()).length < 32) {
                bl = false;
            }
        }
        return bl;
    }

    public static byte[] reformatASN1(byte[] byArray) {
        System.setProperty("com.icbc.bcprov.org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] byArray2 = null;
        try {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
            if (aSN1Sequence.size() == 2) {
                byte[] byArray3 = ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue().toByteArray();
                byte[] byArray4 = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue().toByteArray();
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                aSN1EncodableVector.add(new ASN1Integer(new BigInteger(1, byArray3)));
                aSN1EncodableVector.add(new ASN1Integer(new BigInteger(1, byArray4)));
                byArray2 = new DERSequence(aSN1EncodableVector).getEncoded("DER");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.setProperty("com.icbc.bcprov.org.bouncycastle.asn1.allow_unsafe_integer", "false");
            return null;
        }
        System.setProperty("com.icbc.bcprov.org.bouncycastle.asn1.allow_unsafe_integer", "false");
        return byArray2;
    }
}

