/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.cert;

import com.icbc.bcpkix.org.bouncycastle.cert.X509CertificateHolder;
import com.icbc.bcpkix.org.bouncycastle.cert.X509v3CertificateBuilder;
import com.icbc.bcpkix.org.bouncycastle.cert.bc.BcX509v3CertificateBuilder;
import com.icbc.bcpkix.org.bouncycastle.operator.ContentSigner;
import com.icbc.bcpkix.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.icbc.bcpkix.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcContentSignerBuilder;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import com.icbc.bcprov.org.bouncycastle.asn1.x500.X500Name;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.util.io.pem.PemObject;
import com.icbc.bcprov.org.bouncycastle.util.io.pem.PemWriter;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.cert.IcbcContentSignerBuilder;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.util.Date;

public class CertificateBuilder {
    private X500Name issuer = null;
    private X500Name subject = null;
    private BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
    private Date notBefore = new Date(System.currentTimeMillis() - 50000L);
    private Date notAfter = new Date(System.currentTimeMillis() + 5000000000000L);
    private HsmKeyParameter issuerPrivateKey = null;

    public void setIssuer(X500Name x500Name) {
        if (x500Name != null) {
            this.issuer = x500Name;
        }
    }

    public void setSubject(X500Name x500Name) {
        if (x500Name != null) {
            this.subject = x500Name;
        }
    }

    public void setSerial(BigInteger bigInteger) {
        if (bigInteger != null) {
            this.serial = bigInteger;
        }
    }

    public void setValidDate(Date date, Date date2) {
        if (date != null) {
            this.notBefore = date;
        }
        if (date2 != null) {
            this.notAfter = date2;
        }
    }

    public void setIssuerPrivateKey(HsmKeyParameter hsmKeyParameter) {
        if (hsmKeyParameter != null) {
            this.issuerPrivateKey = hsmKeyParameter;
        }
    }

    public String generateCertificate(HsmKeyParameter hsmKeyParameter) throws Exception {
        Object object;
        Object object2;
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        AsymmetricKeyParameter asymmetricKeyParameter2 = null;
        boolean bl = false;
        if (hsmKeyParameter instanceof ClearKeyParameter) {
            try {
                asymmetricKeyParameter = (AsymmetricKeyParameter)((ClearKeyParameter)hsmKeyParameter).getBCkey();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Exception("subject PublicKey error!");
            }
        }
        if (this.issuerPrivateKey instanceof ClearKeyParameter) {
            try {
                asymmetricKeyParameter2 = (AsymmetricKeyParameter)((ClearKeyParameter)this.issuerPrivateKey).getBCkey();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Exception("issuer PrivateKey error!");
            }
            if ("SM2".equalsIgnoreCase(((ClearKeyParameter)this.issuerPrivateKey).getAlgorithm())) {
                bl = true;
            }
        } else if (this.issuerPrivateKey instanceof IcbcAsymmetricKeyParameter) {
            try {
                asymmetricKeyParameter2 = (AsymmetricKeyParameter)((IcbcAsymmetricKeyParameter)this.issuerPrivateKey).getBCkey();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Exception("issuer Private Key error!");
            }
        }
        BcContentSignerBuilder bcContentSignerBuilder = null;
        if (bl) {
            object2 = new DefaultSignatureAlgorithmIdentifierFinder().find("SM3WITHSM2");
            object = new DefaultDigestAlgorithmIdentifierFinder().find("SM3");
            bcContentSignerBuilder = new IcbcContentSignerBuilder((AlgorithmIdentifier)object2, (AlgorithmIdentifier)object);
        } else {
            object2 = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256WITHRSA");
            object = new DefaultDigestAlgorithmIdentifierFinder().find("SHA256");
            bcContentSignerBuilder = new BcRSAContentSignerBuilder((AlgorithmIdentifier)object2, (AlgorithmIdentifier)object);
        }
        object2 = bcContentSignerBuilder.build(asymmetricKeyParameter2);
        object = new BcX509v3CertificateBuilder(this.issuer, this.serial, this.notBefore, this.notAfter, this.subject, asymmetricKeyParameter);
        X509CertificateHolder x509CertificateHolder = ((X509v3CertificateBuilder)object).build((ContentSigner)object2);
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PemWriter pemWriter = new PemWriter(new OutputStreamWriter(byteArrayOutputStream));
        try {
            pemWriter.writeObject(new PemObject("CERTIFICATE", x509CertificateHolder.getEncoded()));
            pemWriter.close();
        }
        catch (Exception exception) {
            throw new CertificateEncodingException("can't encode certificate to PEM");
        }
        string = byteArrayOutputStream.toString();
        return string;
    }
}

