/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.cert;

import com.icbc.bcpkix.org.bouncycastle.operator.OperatorCreationException;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import com.icbc.bcprov.org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.icbc.bcprov.org.bouncycastle.crypto.Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.Signer;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA256Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA384Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA512Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SM3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.signers.SM2Signer;
import com.icbc.bcprov.org.bouncycastle.crypto.util.PublicKeyFactory;
import com.icbc.bcprov.org.bouncycastle.util.Memoable;
import com.icbc.hsm.software.cert.CertHelper;
import com.icbc.hsm.utils.encoders.Hex;
import java.io.IOException;

public class GmContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals(GMObjectIdentifiers.sm2sign_with_sm3)) {
            return CertHelper.parsePublicSm2(Hex.toHexString(subjectPublicKeyInfo.getPublicKeyData().getOctets()));
        }
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        Memoable memoable;
        if (algorithmIdentifier.getAlgorithm().equals(GMObjectIdentifiers.sm2sign_with_sm3)) {
            memoable = new SM3Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(GMObjectIdentifiers.sm2sign_with_sha256)) {
            memoable = new SHA256Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(GMObjectIdentifiers.sm2sign_with_sha384)) {
            memoable = new SHA384Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(GMObjectIdentifiers.sm2sign_with_sha512)) {
            memoable = new SHA512Digest();
        } else {
            throw new OperatorCreationException("Unsupported hash algorithm");
        }
        return new SM2Signer((Digest)((Object)memoable));
    }
}

