/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.base.handler.resolver;

import com.tydic.order.base.annotation.InjectQualifier;
import com.tydic.order.base.handler.QualifierAnnotationResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class InjectQualifierAnnotationResolver
implements QualifierAnnotationResolver {
    private static Properties CONTEXT_PROPS = new Properties();
    private static Logger logger = LoggerFactory.getLogger(InjectQualifierAnnotationResolver.class);

    @Override
    public boolean hasAnnotation(Field field) {
        if (field == null) {
            return false;
        }
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            if (!(annotation instanceof InjectQualifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object invoke(Object bean, String beanName, Field field, ApplicationContext applicationContext) throws BeansException {
        InjectQualifier qualifier = field.getDeclaredAnnotation(InjectQualifier.class);
        Object qualifierBean = null;
        qualifierBean = !StringUtils.isEmpty((Object)qualifier.value()) ? applicationContext.getBean(qualifier.value()) : this.findQualifierBean(field, applicationContext);
        if (null != qualifierBean) {
            this.invokeLog(beanName, field);
            return this.getQualifierBeanBy(bean, field, qualifierBean);
        }
        return null;
    }

    private Object findQualifierBean(Field field, ApplicationContext applicationContext) {
        Object bean;
        block8: {
            bean = null;
            Map map = new HashMap(16);
            try {
                map = applicationContext.getBeansOfType(field.getType());
                String beanName = this.getBeanByProperty(applicationContext, field.getType().getTypeName());
                if (map != null) {
                    if (StringUtils.isEmpty((Object)beanName)) {
                        if (map.size() > 1) {
                            logger.error("Bean\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u63a5\u53e3\u7c7b\u578b" + field.getType() + "\u7684\u5b9e\u73b0,\u6709\u591a\u4e2a\uff0c\u6ca1\u6709\u6307\u5b9a\u5177\u4f53\u7684\u5b9e\u73b0bean\uff0c\u8bf7\u914d\u7f6e\u83b7\u53d6\u8bbe\u7f6e\u503c");
                            throw new BeanInitializationException("Bean\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u63a5\u53e3\u7c7b\u578b" + field.getType() + "\u7684\u5b9e\u73b0,\u6709\u591a\u4e2a\uff0c\u6ca1\u6709\u6307\u5b9a\u5177\u4f53\u7684\u4f7f\u7528\uff0c\u8bf7\u914d\u7f6e\u83b7\u53d6\u8bbe\u7f6e\u503c");
                        }
                        for (Object o : map.keySet()) {
                            if (logger.isInfoEnabled()) {
                                logger.info("\u670d\u52a1\u540d\u79f0\uff1akey=" + o + "\uff0c\u6ce8\u5165\u7684\u5b9e\u9645\u7c7b\u578bvalue=" + map.get(o));
                            }
                            bean = map.get(o);
                        }
                    } else {
                        bean = map.get(beanName);
                    }
                    break block8;
                }
                throw new BeanInitializationException("Bean\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u6ca1\u6709\u5b9a\u4e49\u63a5\u53e3\u7c7b\u578b" + field.getType() + "\u7684\u5b9e\u73b0");
            }
            catch (BeansException e) {
                logger.error("Can't find the service of {}", (Object)field.getName());
            }
        }
        return bean;
    }

    private Object getQualifierBeanBy(Object bean, Field field, Object qualifierBean) throws BeansException {
        try {
            field.setAccessible(true);
            field.set(bean, qualifierBean);
            return bean;
        }
        catch (Exception e) {
            throw new BeanInitializationException("Bean\u521d\u59cb\u5316\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }

    private void invokeLog(String beanName, Field field) {
        if (logger.isInfoEnabled()) {
            logger.info("\u5b8c\u6210\u91cd\u65b0\u88c5\u914dBean\u540d\u79f0\u4e3a:" + beanName + "' \u7684\u5b57\u6bb5\u540d\u79f0\u4e3a:" + field.getName());
        }
    }

    private String getBeanByProperty(ApplicationContext context, String type) {
        try {
            Properties props = (Properties)context.getBean("propertiesFileLoader", Properties.class);
            CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)CONTEXT_PROPS);
        }
        catch (NoSuchBeanDefinitionException e) {
            Properties props = (Properties)context.getBean("propertyConfigurer", Properties.class);
            CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)CONTEXT_PROPS);
        }
        catch (Exception e) {
            logger.info("load properties error:" + e.getMessage());
        }
        String beanName = CONTEXT_PROPS.getProperty(type);
        return beanName;
    }
}

