/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.base.handler.resolver;

import com.tydic.order.base.handler.QualifierAnnotationResolver;
import com.tydic.order.base.handler.resolver.InjectQualifierAnnotationResolver;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;

public class InjectQualifierProcessor
implements BeanPostProcessor {
    private static List<QualifierAnnotationResolver> globalHandles = new ArrayList<QualifierAnnotationResolver>();
    @Autowired
    private ApplicationContext applicationContext;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return this.invokeBean(bean, beanName);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private Object invokeBean(Object bean, String beanName) {
        Field[] fields;
        for (Field field : fields = this.getDeclaredFields(bean)) {
            for (QualifierAnnotationResolver handle : globalHandles) {
                if (!handle.hasAnnotation(field)) continue;
                bean = handle.invoke(bean, beanName, field, this.applicationContext);
            }
        }
        return bean;
    }

    private Field[] getDeclaredFields(Object bean) {
        if (AopUtils.isAopProxy((Object)bean)) {
            try {
                return bean.getClass().getSuperclass().getDeclaredFields();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return bean.getClass().getDeclaredFields();
    }

    static {
        globalHandles.add(new InjectQualifierAnnotationResolver());
    }
}

