/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.vmc.client;

import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.client.ApiClient;
import com.vmware.vapi.client.ApiClients;
import com.vmware.vapi.client.Configuration;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.protocol.client.rest.authn.CustomHeaderAuthenticationAppender;
import com.vmware.vapi.internal.protocol.client.rest.authn.HttpRequestAuthorizer;
import com.vmware.vapi.vmc.client.authz.AuthzRefreshingRequestExecutorFactory;
import com.vmware.vapi.vmc.client.authz.CspAccessRequestor;
import com.vmware.vapi.vmc.client.authz.CspSecurityContext;
import java.util.Objects;

public class VmcClients {
    public static final String VMC_URL = "https://vmc.vmware.com";
    public static final String CSP_URL = "https://console.cloud.vmware.com/csp/gateway/am/api/auth/api-tokens/authorize";
    private static final String AUTH_TOKEN_HEADER = "csp-auth-token";

    public static ApiClient createDefault(char[] refreshToken) {
        return new Builder().setRefreshToken(refreshToken).build();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static class Builder {
        private char[] refreshToken;
        private String baseUrl = "https://vmc.vmware.com";
        private String authorizationUrl = "https://console.cloud.vmware.com/csp/gateway/am/api/auth/api-tokens/authorize";

        public Builder setRefreshToken(char[] refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder setBaseUrl(String baseUrl) {
            this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl cannot be null");
            return this;
        }

        public Builder setAuthorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
            return this;
        }

        public ApiClient build() {
            Configuration.Builder configBuilder = new Configuration.Builder();
            if (this.refreshToken != null) {
                CspSecurityContext securityCtx = new CspSecurityContext(this.refreshToken);
                configBuilder.register("vapi.stub.config", (Object)new StubConfiguration((ExecutionContext.SecurityContext)securityCtx));
            }
            if (this.authorizationUrl != null) {
                CustomHeaderAuthenticationAppender headerAppender = new CustomHeaderAuthenticationAppender(VmcClients.AUTH_TOKEN_HEADER);
                CspAccessRequestor tokenRetriever = new CspAccessRequestor(this.authorizationUrl);
                configBuilder.register("rest.request.executor", (Object)new AuthzRefreshingRequestExecutorFactory((HttpRequestAuthorizer)headerAppender, tokenRetriever));
            }
            return ApiClients.newRestClient((String)this.baseUrl, (Configuration)configBuilder.build());
        }
    }
}

