/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.vmc.client.authz;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.internal.protocol.client.rest.DefaultRequestExecutorFactory;
import com.vmware.vapi.internal.protocol.client.rest.RequestExecutor;
import com.vmware.vapi.internal.protocol.client.rest.RequestExecutorFactory;
import com.vmware.vapi.internal.protocol.client.rest.ResponseParser;
import com.vmware.vapi.internal.protocol.client.rest.authn.HttpRequestAuthorizer;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;
import com.vmware.vapi.internal.protocol.client.rpc.RestTransport;
import com.vmware.vapi.vmc.client.authz.AccessAuthorization;
import com.vmware.vapi.vmc.client.authz.AccessRequestor;
import com.vmware.vapi.vmc.client.authz.AuthorizationResponseHandler;
import com.vmware.vapi.vmc.client.authz.CspSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthzRefreshingRequestExecutorFactory
implements RequestExecutorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthzRefreshingRequestExecutorFactory.class);
    private final HttpRequestAuthorizer authorizer;
    private final AccessRequestor accessRequestor;

    public AuthzRefreshingRequestExecutorFactory(HttpRequestAuthorizer authorizer, AccessRequestor accessRequestor) {
        this.authorizer = authorizer;
        this.accessRequestor = accessRequestor;
    }

    public RequestExecutor createRequestExecutor(RestTransport transport, ResponseParser parser) {
        return new AuthzRefreshingRequestExecutor(transport, parser);
    }

    private static interface RefreshAuthzAccessHandler {
        public void onComplete(boolean var1);
    }

    private class AuthzRefreshingRequestExecutor
    implements RequestExecutor {
        private final RestTransport transport;
        private final ResponseParser parser;

        AuthzRefreshingRequestExecutor(RestTransport transport, ResponseParser parser) {
            this.transport = transport;
            this.parser = parser;
        }

        public void execute(final String serviceId, final String operationId, final HttpRequest request, ExecutionContext ctx, final AsyncHandle<MethodResult> asyncHandle) {
            final ExecutionContext.SecurityContext securityContext = ctx.retrieveSecurityContext();
            RefreshAuthzAccessHandler refreshTokenHandler = new RefreshAuthzAccessHandler(){

                @Override
                public void onComplete(boolean refreshed) {
                    Object responseHandler = refreshed ? new DefaultRequestExecutorFactory.DefaultHttpResponseHandler(AuthzRefreshingRequestExecutor.this.parser, serviceId, operationId, asyncHandle) : new AuthzRefreshingHttpResponseHandler(AuthzRefreshingRequestExecutor.this.parser, serviceId, operationId, (AsyncHandle<MethodResult>)asyncHandle, request, securityContext);
                    AuthzRefreshingRequestExecutor.this.authorizeAndExecute(request, securityContext, (HttpRequest.HttpResponseHandler)responseHandler);
                }
            };
            this.refreshContextIfNeeded(securityContext, refreshTokenHandler);
        }

        private void authorizeAndExecute(HttpRequest request, ExecutionContext.SecurityContext securityContext, HttpRequest.HttpResponseHandler handler) {
            AuthzRefreshingRequestExecutorFactory.this.authorizer.authorize(request, securityContext);
            this.transport.execute(request, handler, new ExecutionContext());
        }

        private void forceRefreshContext(ExecutionContext.SecurityContext securityContext, RefreshAuthzAccessHandler handler) {
            this.refreshContext(securityContext, false, handler);
        }

        private void refreshContextIfNeeded(ExecutionContext.SecurityContext securityContext, RefreshAuthzAccessHandler handler) {
            this.refreshContext(securityContext, true, handler);
        }

        private void refreshContext(ExecutionContext.SecurityContext securityContext, boolean refreshOnlyIfNeeded, final RefreshAuthzAccessHandler handler) {
            if (!(securityContext instanceof CspSecurityContext)) {
                LOGGER.warn("Access token cannot be refreshed - CspSecurityContext is not set");
                handler.onComplete(false);
                return;
            }
            final CspSecurityContext cspCtx = (CspSecurityContext)securityContext;
            if (refreshOnlyIfNeeded && !cspCtx.needsRefresh()) {
                LOGGER.trace("Access token is still valid. No need for refresh");
                handler.onComplete(false);
                return;
            }
            LOGGER.trace("Access token to be refreshed...");
            AuthorizationResponseHandler authorizationResponseHandler = new AuthorizationResponseHandler(){

                @Override
                public void onResult(AccessAuthorization response) {
                    LOGGER.debug("Access token was refreshed. The new one expires in {} seconds", (Object)response.getExpiration());
                    cspCtx.setAccessToken(response.getAccessToken());
                    handler.onComplete(true);
                }

                @Override
                public void onError(Exception ex) {
                    LOGGER.warn("Unable to refresh access token", (Throwable)ex);
                    handler.onComplete(false);
                }
            };
            AuthzRefreshingRequestExecutorFactory.this.accessRequestor.requestAccess(this.transport, securityContext, authorizationResponseHandler);
        }

        private class AuthzRefreshingHttpResponseHandler
        extends DefaultRequestExecutorFactory.DefaultHttpResponseHandler {
            private final HttpRequest request;
            private final ExecutionContext.SecurityContext securityContext;

            public AuthzRefreshingHttpResponseHandler(ResponseParser parser, String serviceId, String operationId, AsyncHandle<MethodResult> asyncHandle, HttpRequest request, ExecutionContext.SecurityContext securityContext) {
                super(parser, serviceId, operationId, asyncHandle);
                this.request = request;
                this.securityContext = securityContext;
            }

            public void onResult(final HttpResponse response) {
                if (response.getStatusCode() == 401) {
                    LOGGER.debug("Received 401. Access token might have expired. Will refresh it and try again.");
                    AuthzRefreshingRequestExecutor.this.forceRefreshContext(this.securityContext, new RefreshAuthzAccessHandler(){

                        @Override
                        public void onComplete(boolean refreshed) {
                            if (refreshed) {
                                LOGGER.trace("Access token got refreshed. Retrying invocation");
                                AuthzRefreshingRequestExecutor.this.authorizeAndExecute(AuthzRefreshingHttpResponseHandler.this.request, AuthzRefreshingHttpResponseHandler.this.securityContext, (HttpRequest.HttpResponseHandler)new DefaultRequestExecutorFactory.DefaultHttpResponseHandler(AuthzRefreshingHttpResponseHandler.this.parser, AuthzRefreshingHttpResponseHandler.this.serviceId, AuthzRefreshingHttpResponseHandler.this.operationId, AuthzRefreshingHttpResponseHandler.this.asyncHandle));
                                return;
                            }
                            AuthzRefreshingHttpResponseHandler.super.onResult(response);
                        }
                    });
                    return;
                }
                super.onResult(response);
            }
        }
    }
}

