/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.vmc.client.authz;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.protocol.client.rest.authn.FetchTokenException;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;
import com.vmware.vapi.internal.protocol.client.rpc.RestTransport;
import com.vmware.vapi.internal.protocol.client.rpc.http.HttpRequestImpl;
import com.vmware.vapi.vmc.client.authz.AccessAuthorization;
import com.vmware.vapi.vmc.client.authz.AccessRequestor;
import com.vmware.vapi.vmc.client.authz.AuthorizationResponseHandler;
import com.vmware.vapi.vmc.client.authz.CspSecurityContext;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class CspAccessRequestor
implements AccessRequestor {
    private final String authorizationUrl;

    public CspAccessRequestor(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    @Override
    public void requestAccess(RestTransport transport, ExecutionContext.SecurityContext ctx, AuthorizationResponseHandler handler) {
        if (!(ctx instanceof CspSecurityContext)) {
            handler.onError((Exception)((Object)new FetchTokenException("Refresh token is not set. ctx must be a CspSecurityContext instance")));
            return;
        }
        char[] refreshToken = ((CspSecurityContext)ctx).getRefreshToken();
        HttpRequestImpl request = new HttpRequestImpl();
        request.setUrl(this.authorizationUrl);
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        request.setBody(("refresh_token=" + new String(refreshToken)).getBytes(StandardCharsets.UTF_8));
        request.setMethod(HttpRequest.HttpMethod.POST);
        transport.execute((HttpRequest)request, (HttpRequest.HttpResponseHandler)new TokenResponseHandler(handler), new ExecutionContext());
    }

    static class TokenResponseHandler
    implements HttpRequest.HttpResponseHandler {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
        private static final String ACCESS_TOKEN_KEY = "access_token";
        private static final String EXPIRATION_KEY = "expires_in";
        private static final int EXPIRATION_DEFAULT_VALUE = 0;
        private final AuthorizationResponseHandler handler;

        public TokenResponseHandler(AuthorizationResponseHandler handler) {
            this.handler = Objects.requireNonNull(handler, "handler cannot be null");
        }

        public void onResult(HttpResponse response) {
            JsonNode jsonNode = null;
            try {
                jsonNode = TokenResponseHandler.parse(response);
            }
            catch (FetchTokenException e) {
                this.handler.onError((Exception)((Object)e));
                return;
            }
            final JsonNode tokenNode = jsonNode.get(ACCESS_TOKEN_KEY);
            final JsonNode expirationValueNode = jsonNode.get(EXPIRATION_KEY);
            this.handler.onResult(new AccessAuthorization(){

                @Override
                public int getExpiration() {
                    if (expirationValueNode == null) {
                        return 0;
                    }
                    return expirationValueNode.asInt(0);
                }

                @Override
                public char[] getAccessToken() {
                    return tokenNode.asText().toCharArray();
                }
            });
        }

        static JsonNode parse(HttpResponse response) {
            int responseStatusCode = 0;
            try {
                responseStatusCode = response.getStatusCode();
            }
            catch (RuntimeException e) {
                throw new FetchTokenException("Unable to obtain token response status", (Throwable)e);
            }
            byte[] responseBody = null;
            try {
                responseBody = response.getBody();
            }
            catch (RuntimeException e) {
                throw new FetchTokenException("Unable to obtain token response body", (Throwable)e);
            }
            if (responseStatusCode < 200 || responseStatusCode > 201) {
                throw new FetchTokenException(TokenResponseHandler.addBody("Invalid token response status: " + responseStatusCode, responseBody));
            }
            JsonNode jsonNode = null;
            try {
                jsonNode = OBJECT_MAPPER.readTree(responseBody);
            }
            catch (Exception e) {
                throw new FetchTokenException(TokenResponseHandler.addBody("Unable to parse token response as JSON:", responseBody), (Throwable)e);
            }
            if (jsonNode == null) {
                throw new FetchTokenException("Empty token response");
            }
            JsonNode tokenNode = jsonNode.get(ACCESS_TOKEN_KEY);
            if (tokenNode == null || tokenNode.isNull()) {
                throw new FetchTokenException("Missing token");
            }
            return jsonNode;
        }

        private static String addBody(String message, byte[] body) {
            if (body == null || body.length == 0) {
                return message;
            }
            String bodyStr = new String(body, StandardCharsets.UTF_8);
            return message + "\n" + bodyStr;
        }

        public void onError(Exception ex) {
            this.handler.onError(ex);
        }
    }
}

