/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.vmc.client.authz;

import com.vmware.vapi.core.ExecutionContext;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class CspSecurityContext
implements ExecutionContext.SecurityContext {
    public static final String REFRESH_TOKEN = "refreshToken";
    protected final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    public CspSecurityContext(char[] refreshToken) {
        this.properties.put("authn_scheme_id", "com.vmware.vapi.std.security.oauth");
        this.properties.put(REFRESH_TOKEN, Objects.requireNonNull(refreshToken, "refreshToken cannot be null"));
    }

    public void setAccessToken(char[] accessToken) {
        this.properties.put("accessToken", accessToken);
    }

    public boolean needsRefresh() {
        return !this.properties.containsKey("accessToken");
    }

    public char[] getRefreshToken() {
        return (char[])this.properties.get(REFRESH_TOKEN);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Map<String, Object> getAllProperties() {
        return Collections.unmodifiableMap(this.properties);
    }
}

