/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.api.async;

import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.async.IpmiListener;
import com.veraxsystems.vxipmi.api.async.messages.IpmiError;
import com.veraxsystems.vxipmi.api.async.messages.IpmiResponse;
import com.veraxsystems.vxipmi.api.async.messages.IpmiResponseData;
import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.PropertiesManager;
import com.veraxsystems.vxipmi.connection.ConnectionListener;
import com.veraxsystems.vxipmi.connection.ConnectionManager;
import com.veraxsystems.vxipmi.connection.StateConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class IpmiAsyncConnector
implements ConnectionListener {
    private ConnectionManager connectionManager;
    private int retries;
    private List<IpmiListener> listeners = new ArrayList<IpmiListener>();
    private static Logger logger = Logger.getLogger(IpmiAsyncConnector.class);

    public IpmiAsyncConnector(int port) throws IOException {
        this.connectionManager = new ConnectionManager(port);
        this.loadProperties();
    }

    public IpmiAsyncConnector(int port, InetAddress address) throws IOException {
        this.connectionManager = new ConnectionManager(port, address);
        this.loadProperties();
    }

    private void loadProperties() throws IOException {
        this.retries = Integer.parseInt(PropertiesManager.getInstance().getProperty("retries"));
    }

    public ConnectionHandle createConnection(InetAddress address) throws FileNotFoundException, IOException {
        int handle = this.connectionManager.createConnection(address);
        this.connectionManager.getConnection(handle).registerListener(this);
        return new ConnectionHandle(handle);
    }

    public List<CipherSuite> getAvailableCipherSuites(ConnectionHandle connectionHandle) throws Exception {
        int tries = 0;
        List<CipherSuite> result = null;
        while (tries <= this.retries && result == null) {
            try {
                ++tries;
                result = this.connectionManager.getAvailableCipherSuites(connectionHandle.getHandle());
            }
            catch (IPMIException e) {
                logger.warn((Object)"Failed to receive answer, cause:", (Throwable)e);
                if (tries <= this.retries) continue;
                throw e;
            }
            catch (StateConnectionException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    logger.warn((Object)("Failed to receive answer, cause: " + e.getMessage()));
                } else {
                    logger.warn((Object)"Failed to receive answer, cause:", (Throwable)e);
                }
                if (tries <= this.retries) continue;
                throw e;
            }
        }
        return result;
    }

    public List<CipherSuite> getAllCipherSuites(ConnectionHandle connectionHandle) throws StateConnectionException {
        List<CipherSuite> result = this.connectionManager.getAllCipherSuites(connectionHandle.getHandle());
        return result;
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(ConnectionHandle connectionHandle, CipherSuite cipherSuite, PrivilegeLevel requestedPrivilegeLevel) throws Exception {
        int tries = 0;
        GetChannelAuthenticationCapabilitiesResponseData result = null;
        while (tries <= this.retries && result == null) {
            try {
                ++tries;
                result = this.connectionManager.getChannelAuthenticationCapabilities(connectionHandle.getHandle(), cipherSuite, requestedPrivilegeLevel);
                connectionHandle.setCipherSuite(cipherSuite);
                connectionHandle.setPrivilegeLevel(requestedPrivilegeLevel);
            }
            catch (StateConnectionException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    logger.warn((Object)("Failed to receive answer, cause:" + e.getMessage()));
                } else {
                    logger.warn((Object)"Failed to receive answer, cause:", (Throwable)e);
                }
                logger.warn((Object)"Failed to receive answer, cause:", (Throwable)e);
                if (tries <= this.retries) continue;
                throw e;
            }
        }
        return result;
    }

    public void openSession(ConnectionHandle connectionHandle, String username, String password, byte[] bmcKey) throws Exception {
        int tries = 0;
        boolean succeded = false;
        while (tries <= this.retries && !succeded) {
            try {
                ++tries;
                this.connectionManager.startSession(connectionHandle.getHandle(), connectionHandle.getCipherSuite(), connectionHandle.getPrivilegeLevel(), username, password, bmcKey);
                succeded = true;
            }
            catch (StateConnectionException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    logger.warn((Object)("Failed to receive answer, cause:" + e.getMessage()));
                } else {
                    logger.warn((Object)"Failed to receive answer, cause:", (Throwable)e);
                }
                if (tries <= this.retries) continue;
                throw e;
            }
        }
    }

    public void closeSession(ConnectionHandle connectionHandle) throws Exception {
        if (!this.connectionManager.getConnection(connectionHandle.getHandle()).isSessionValid()) {
            return;
        }
        int tries = 0;
        boolean succeded = false;
        while (tries <= this.retries && !succeded) {
            try {
                ++tries;
                this.connectionManager.getConnection(connectionHandle.getHandle()).closeSession();
                succeded = true;
            }
            catch (StateConnectionException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    logger.warn((Object)("Failed to receive answer, cause:" + e.getMessage()));
                } else {
                    logger.warn((Object)"Failed to receive answer, cause:", (Throwable)e);
                }
                if (tries <= this.retries) continue;
                throw e;
            }
        }
    }

    public int sendMessage(ConnectionHandle connectionHandle, IpmiCommandCoder request) throws Exception {
        int tries = 0;
        int tag = -1;
        while (tries <= this.retries && tag < 0) {
            try {
                ++tries;
                while (tag < 0) {
                    tag = this.connectionManager.getConnection(connectionHandle.getHandle()).sendIpmiCommand(request);
                    if (tag >= 0) continue;
                    Thread.sleep(10L);
                }
                logger.debug((Object)("Sending message with tag " + tag + ", try " + tries));
            }
            catch (StateConnectionException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    logger.warn((Object)("Failed to receive answer, cause:" + e.getMessage()));
                } else {
                    logger.warn((Object)"Failed to receive answer, cause:", (Throwable)e);
                }
                if (tries <= this.retries) continue;
                throw e;
            }
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(IpmiListener listener) {
        List<IpmiListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(IpmiListener listener) {
        List<IpmiListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(ResponseData responseData, int handle, int tag, Exception exception) {
        IpmiResponse response = null;
        if (responseData == null || exception != null) {
            if (exception == null) {
                exception = new Exception("Empty response");
            }
            response = new IpmiError(exception, tag, new ConnectionHandle(handle));
        } else {
            response = new IpmiResponseData(responseData, tag, new ConnectionHandle(handle));
        }
        List<IpmiListener> list = this.listeners;
        synchronized (list) {
            for (IpmiListener listener : this.listeners) {
                if (listener == null) continue;
                listener.notify(response);
            }
        }
    }

    public void closeConnection(ConnectionHandle handle) {
        this.connectionManager.getConnection(handle.getHandle()).unregisterListener(this);
        this.connectionManager.closeConnection(handle.getHandle());
    }

    public void tearDown() {
        this.connectionManager.close();
    }

    public void setTimeout(ConnectionHandle handle, int timeout) {
        this.connectionManager.getConnection(handle.getHandle()).setTimeout(timeout);
    }
}

