/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.api.sync;

import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.async.IpmiAsyncConnector;
import com.veraxsystems.vxipmi.api.sync.MessageListener;
import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.PropertiesManager;
import com.veraxsystems.vxipmi.connection.StateConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class IpmiConnector {
    private static final Logger logger = Logger.getLogger(IpmiConnector.class);
    private final IpmiAsyncConnector asyncConnector;
    private int retries;
    private int idleTime;
    private int timeout;
    private Random random = new Random(System.currentTimeMillis());

    public IpmiConnector(int port) throws FileNotFoundException, IOException {
        this.asyncConnector = new IpmiAsyncConnector(port);
        this.loadProperties();
    }

    public IpmiConnector(int port, InetAddress address) throws FileNotFoundException, IOException {
        this.asyncConnector = new IpmiAsyncConnector(port, address);
        this.loadProperties();
    }

    private void loadProperties() throws IOException {
        PropertiesManager manager = PropertiesManager.getInstance();
        this.retries = Integer.parseInt(manager.getProperty("retries"));
        this.idleTime = Integer.parseInt(manager.getProperty("idleTime"));
    }

    public ConnectionHandle createConnection(InetAddress address) throws FileNotFoundException, IOException {
        return this.asyncConnector.createConnection(address);
    }

    public List<CipherSuite> getAvailableCipherSuites(ConnectionHandle connectionHandle) throws Exception {
        return this.asyncConnector.getAvailableCipherSuites(connectionHandle);
    }

    public List<CipherSuite> getAllCipherSuites(ConnectionHandle connectionHandle) throws Exception {
        return this.asyncConnector.getAllCipherSuites(connectionHandle);
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(ConnectionHandle connectionHandle, CipherSuite cipherSuite, PrivilegeLevel requestedPrivilegeLevel) throws Exception {
        return this.asyncConnector.getChannelAuthenticationCapabilities(connectionHandle, cipherSuite, requestedPrivilegeLevel);
    }

    public void openSession(ConnectionHandle connectionHandle, String username, String password, byte[] bmcKey) throws Exception {
        this.asyncConnector.openSession(connectionHandle, username, password, bmcKey);
    }

    public void closeSession(ConnectionHandle connectionHandle) throws Exception {
        this.asyncConnector.closeSession(connectionHandle);
    }

    public ResponseData sendMessage(ConnectionHandle connectionHandle, IpmiCommandCoder request) throws Exception {
        int tries = 0;
        MessageListener listener = new MessageListener(connectionHandle);
        this.asyncConnector.registerListener(listener);
        ResponseData data = null;
        int previousTag = -1;
        while (data == null) {
            long sleepTime;
            try {
                int tag = this.asyncConnector.sendMessage(connectionHandle, request);
                logger.debug((Object)("Sending message with tag " + tag + ", try " + ++tries + ", previous tag " + previousTag));
                previousTag = tag;
                data = listener.waitForAnswer(tag, this.timeout);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (StateConnectionException e) {
                throw e;
            }
            catch (IPMIException e) {
                if (e.getCompletionCode() == CompletionCode.InitializationInProgress || e.getCompletionCode() == CompletionCode.InsufficientResources || e.getCompletionCode() == CompletionCode.NodeBusy || e.getCompletionCode() == CompletionCode.Timeout) {
                    if (tries > this.retries) {
                        throw e;
                    }
                    sleepTime = this.random.nextLong() % (long)(this.idleTime / 2) + (long)(this.idleTime / 2);
                    Thread.sleep(sleepTime);
                    logger.warn((Object)"Receiving message failed, retrying", (Throwable)e);
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                if (tries > this.retries) {
                    throw e;
                }
                if (e instanceof IOException) {
                    logger.warn((Object)("Receiving message failed " + e.getMessage() + ", retrying"));
                } else {
                    logger.warn((Object)"Receiving message failed, retrying", (Throwable)e);
                }
                sleepTime = this.random.nextLong() % (long)(this.idleTime / 2) + (long)(this.idleTime / 2);
                Thread.sleep(sleepTime);
            }
        }
        this.asyncConnector.unregisterListener(listener);
        return data;
    }

    public void closeConnection(ConnectionHandle handle) {
        this.asyncConnector.closeConnection(handle);
    }

    public void tearDown() {
        this.asyncConnector.tearDown();
    }

    public void setTimeout(ConnectionHandle handle, int timeout) {
        this.asyncConnector.setTimeout(handle, timeout);
        this.timeout = timeout;
    }
}

