/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.api.sync;

import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.async.IpmiListener;
import com.veraxsystems.vxipmi.api.async.messages.IpmiError;
import com.veraxsystems.vxipmi.api.async.messages.IpmiResponse;
import com.veraxsystems.vxipmi.api.async.messages.IpmiResponseData;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import java.util.ArrayList;
import java.util.List;

public class MessageListener
implements IpmiListener {
    private final ConnectionHandle handle;
    private final IpmiResponseHandler response = new IpmiResponseHandler();
    private final List<IpmiResponse> quickMessages = new ArrayList<IpmiResponse>();
    private int tag;

    public MessageListener(ConnectionHandle handle) {
        this.handle = handle;
        this.tag = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData waitForAnswer(int tag, int timeout) throws Exception {
        if (tag < 0 || tag > 63) {
            throw new Exception("Corrupted message tag");
        }
        this.tag = tag;
        for (IpmiResponse response : this.quickMessages) {
            this.notify(response);
        }
        IpmiResponseHandler ipmiResponseHandler = this.response;
        synchronized (ipmiResponseHandler) {
            while (this.response.response == null) {
                this.response.wait(timeout);
            }
        }
        if (this.response.response instanceof IpmiResponseData) {
            this.tag = -1;
            this.quickMessages.clear();
            return ((IpmiResponseData)this.response.response).getResponseData();
        }
        throw ((IpmiError)this.response.response).getException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void notify(IpmiResponse response) {
        if (response.getHandle().getHandle() == this.handle.getHandle()) {
            if (this.tag == -1) {
                this.quickMessages.add(response);
            } else if (response.getTag() == this.tag) {
                IpmiResponseHandler ipmiResponseHandler = this.response;
                synchronized (ipmiResponseHandler) {
                    this.response.response = response;
                    this.response.notify();
                }
            }
        }
    }

    private static final class IpmiResponseHandler {
        private IpmiResponse response = null;

        private IpmiResponseHandler() {
        }
    }
}

