/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding;

import com.veraxsystems.vxipmi.coding.Decoder;
import com.veraxsystems.vxipmi.coding.Encoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.chassis.GetChassisStatus;
import com.veraxsystems.vxipmi.coding.commands.chassis.GetChassisStatusResponseData;
import com.veraxsystems.vxipmi.coding.commands.fru.BaseUnit;
import com.veraxsystems.vxipmi.coding.commands.fru.GetFruInventoryAreaInfo;
import com.veraxsystems.vxipmi.coding.commands.fru.GetFruInventoryAreaInfoResponseData;
import com.veraxsystems.vxipmi.coding.commands.fru.ReadFruData;
import com.veraxsystems.vxipmi.coding.commands.fru.ReadFruDataResponseData;
import com.veraxsystems.vxipmi.coding.commands.fru.record.BoardInfo;
import com.veraxsystems.vxipmi.coding.commands.fru.record.ChassisInfo;
import com.veraxsystems.vxipmi.coding.commands.fru.record.FruRecord;
import com.veraxsystems.vxipmi.coding.commands.fru.record.ProductInfo;
import com.veraxsystems.vxipmi.coding.commands.sdr.GetSdr;
import com.veraxsystems.vxipmi.coding.commands.sdr.GetSdrRepositoryInfo;
import com.veraxsystems.vxipmi.coding.commands.sdr.GetSdrRepositoryInfoResponseData;
import com.veraxsystems.vxipmi.coding.commands.sdr.GetSdrResponseData;
import com.veraxsystems.vxipmi.coding.commands.sdr.GetSensorReading;
import com.veraxsystems.vxipmi.coding.commands.sdr.GetSensorReadingResponseData;
import com.veraxsystems.vxipmi.coding.commands.sdr.ReserveSdrRepository;
import com.veraxsystems.vxipmi.coding.commands.sdr.ReserveSdrRepositoryResponseData;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.CompactSensorRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.FruDeviceLocatorRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.FullSensorRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.RateUnit;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.ReadingType;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.SensorRecord;
import com.veraxsystems.vxipmi.coding.commands.sel.GetSelEntry;
import com.veraxsystems.vxipmi.coding.commands.sel.GetSelEntryResponseData;
import com.veraxsystems.vxipmi.coding.commands.sel.GetSelInfo;
import com.veraxsystems.vxipmi.coding.commands.sel.GetSelInfoResponseData;
import com.veraxsystems.vxipmi.coding.commands.sel.ReserveSel;
import com.veraxsystems.vxipmi.coding.commands.sel.ReserveSelResponseData;
import com.veraxsystems.vxipmi.coding.commands.sel.SelRecord;
import com.veraxsystems.vxipmi.coding.commands.session.CloseSession;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilities;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelCipherSuites;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelCipherSuitesResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.OpenSession;
import com.veraxsystems.vxipmi.coding.commands.session.OpenSessionResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.Rakp1;
import com.veraxsystems.vxipmi.coding.commands.session.Rakp1ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.Rakp3;
import com.veraxsystems.vxipmi.coding.commands.session.Rakp3ResponseData;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.decoder.PlainCommandv20Decoder;
import com.veraxsystems.vxipmi.coding.protocol.decoder.Protocolv15Decoder;
import com.veraxsystems.vxipmi.coding.protocol.decoder.Protocolv20Decoder;
import com.veraxsystems.vxipmi.coding.protocol.encoder.Protocolv15Encoder;
import com.veraxsystems.vxipmi.coding.protocol.encoder.Protocolv20Encoder;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.crypto.NoSuchPaddingException;
import org.apache.log4j.Logger;

public class DecoderRunner
extends Thread {
    private DatagramSocket socket;
    private static int managedSeqNum;
    private static boolean lock;
    private static Rakp1 r1;
    private static Rakp1ResponseData r1rd;
    private static CipherSuite cs;
    private static Logger logger;
    private static int cssrcv;
    private static int reservation;
    private static int nextRecId;
    private static byte[] cssrec;
    private static List<ReadFruDataResponseData> rd;
    private static int fruId;
    private static int fruSize;

    public static void main(String[] args) throws IOException, InterruptedException, NoSuchAlgorithmException, InvalidKeyException, IllegalArgumentException {
        logger.info((Object)DateFormat.getInstance().format(new Date(new Date().getTime())));
        lock = true;
        DecoderRunner dr = new DecoderRunner();
        dr.socket = new DatagramSocket(6666);
        dr.start();
        Properties properties = new Properties();
        properties.load(new FileInputStream("src/test/resources/test.properties"));
        Thread.sleep(100L);
        InetAddress ad = InetAddress.getByName((String)properties.get("testIp"));
        byte index = 0;
        while (cssrcv >= 16) {
            Thread.sleep(300L);
            lock = true;
            byte[] outmsg = Encoder.encode(new Protocolv20Encoder(), new GetChannelCipherSuites(TypeConverter.intToByte(14), index), 0, 0);
            index = (byte)(index + 1);
            DatagramPacket packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
            dr.socket.send(packet);
            while (lock) {
                Thread.sleep(1L);
            }
        }
        List<CipherSuite> csl = CipherSuite.getCipherSuites(cssrec);
        for (CipherSuite c : csl) {
            try {
                logger.info((Object)(c.getId() + ": " + c.getAuthenticationAlgorithm().getCode() + " " + c.getIntegrityAlgorithm().getCode() + " " + c.getConfidentialityAlgorithm().getCode()));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        cs = csl.get(2);
        Thread.sleep(300L);
        byte[] outmsg = Encoder.encode(new Protocolv15Encoder(), new GetChannelAuthenticationCapabilities(IpmiVersion.V15, IpmiVersion.V20, cs, PrivilegeLevel.User, TypeConverter.intToByte(14)), 0, 0);
        DatagramPacket packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(150L);
        outmsg = Encoder.encode(new Protocolv20Encoder(), new OpenSession(44, PrivilegeLevel.MaximumAvailable, cs), 0, 0);
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(300L);
        while (lock) {
            Thread.sleep(1L);
        }
        lock = true;
        r1 = new Rakp1(managedSeqNum, PrivilegeLevel.User, (String)properties.get("username"), (String)properties.get("password"), null, cs);
        outmsg = Encoder.encode(new Protocolv20Encoder(), r1, 1, 0);
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(150L);
        while (lock) {
            Thread.sleep(1L);
        }
        try {
            cs.initializeAlgorithms(r1.calculateSik(r1rd));
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        outmsg = Encoder.encode(new Protocolv20Encoder(), new Rakp3(0, managedSeqNum, cs, r1, r1rd), 1, 0);
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(150L);
        outmsg = Encoder.encode(new Protocolv20Encoder(), new GetChassisStatus(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus), 1, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(300L);
        outmsg = Encoder.encode(new Protocolv20Encoder(), new GetSdrRepositoryInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus), 2, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(300L);
        outmsg = Encoder.encode(new Protocolv20Encoder(), new ReserveSdrRepository(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus), 3, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        int seq = 4;
        lock = true;
        while (lock) {
            Thread.sleep(1L);
        }
        while (nextRecId < 65535) {
            Thread.sleep(200L);
            logger.info((Object)(">>Sending request for record " + nextRecId));
            outmsg = Encoder.encode(new Protocolv20Encoder(), new GetSdr(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, reservation, nextRecId), seq++, r1.getManagedSystemSessionId());
            packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
            dr.socket.send(packet);
            lock = true;
            while (lock) {
                Thread.sleep(1L);
            }
            if (nextRecId <= 0) continue;
            logger.info((Object)(">>Sending request for reading " + nextRecId));
            outmsg = Encoder.encode(new Protocolv20Encoder(), new GetSensorReading(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, nextRecId), seq++, r1.getManagedSystemSessionId());
            packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
            dr.socket.send(packet);
            lock = true;
            while (lock && nextRecId < 65535) {
                Thread.sleep(1L);
            }
        }
        nextRecId = 0;
        Thread.sleep(300L);
        logger.info((Object)">>Sending GetSelInfo");
        outmsg = Encoder.encode(new Protocolv20Encoder(), new GetSelInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus), seq++, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(300L);
        logger.info((Object)">>Sending Reserve SEL");
        outmsg = Encoder.encode(new Protocolv20Encoder(), new ReserveSel(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus), seq++, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        lock = true;
        while (lock) {
            Thread.sleep(1L);
        }
        while (nextRecId < 65535) {
            Thread.sleep(200L);
            logger.info((Object)(">>Sending request for SEL record " + nextRecId));
            outmsg = Encoder.encode(new Protocolv20Encoder(), new GetSelEntry(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, reservation, nextRecId), seq++, r1.getManagedSystemSessionId());
            packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
            dr.socket.send(packet);
            lock = true;
            while (lock) {
                Thread.sleep(1L);
            }
        }
        Thread.sleep(300L);
        logger.info((Object)">>Sending GetFruInventoryAreaInfo");
        outmsg = Encoder.encode(new Protocolv20Encoder(), new GetFruInventoryAreaInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, fruId), seq++, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        for (int i = 0; i < fruSize; i += 100) {
            Thread.sleep(300L);
            logger.info((Object)">>Sending ReadFruData");
            int cnt = 100;
            if (i + cnt > fruSize) {
                cnt = fruSize % 100;
            }
            outmsg = Encoder.encode(new Protocolv20Encoder(), new ReadFruData(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, fruId, BaseUnit.Bytes, i, cnt), seq++, r1.getManagedSystemSessionId());
            packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
            dr.socket.send(packet);
        }
        Thread.sleep(300L);
        outmsg = Encoder.encode(new Protocolv20Encoder(), new CloseSession(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, r1.getManagedSystemSessionId()), seq++, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(1000L);
        dr.socket.close();
    }

    @Override
    public void run() {
        Object rec;
        ResponseData data;
        DatagramPacket resp;
        super.run();
        cssrec = new byte[0];
        byte[] buffer = null;
        while (cssrcv >= 16) {
            resp = new DatagramPacket(new byte[256], 256);
            try {
                this.socket.receive(resp);
                buffer = new byte[resp.getLength()];
                System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            data = null;
            try {
                data = (GetChannelCipherSuitesResponseData)Decoder.decode(buffer, new Protocolv20Decoder(CipherSuite.getEmpty()), new GetChannelCipherSuites());
            }
            catch (IllegalArgumentException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
            catch (IPMIException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvalidKeyException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (((GetChannelCipherSuitesResponseData)data).getCipherSuiteData() != null) {
                cssrcv = ((GetChannelCipherSuitesResponseData)data).getCipherSuiteData().length;
                logger.info((Object)((GetChannelCipherSuitesResponseData)data).getCipherSuiteData().length);
                byte[] temp = new byte[cssrec.length + cssrcv];
                System.arraycopy(cssrec, 0, temp, 0, cssrec.length);
                System.arraycopy(((GetChannelCipherSuitesResponseData)data).getCipherSuiteData(), 0, temp, cssrec.length, cssrcv);
                cssrec = temp;
            } else {
                cssrcv = 0;
                logger.info((Object)0);
            }
            lock = false;
        }
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        data = null;
        try {
            data = (GetChannelAuthenticationCapabilitiesResponseData)Decoder.decode(buffer, new Protocolv15Decoder(), new GetChannelAuthenticationCapabilities(IpmiVersion.V15, IpmiVersion.V20, cs));
        }
        catch (IllegalArgumentException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (IPMIException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)"---------------------------------------------");
        logger.info((Object)((GetChannelAuthenticationCapabilitiesResponseData)data).getChannelNumber());
        logger.info((Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isIpmiv20Support());
        logger.info((Object)((GetChannelAuthenticationCapabilitiesResponseData)data).getAuthenticationTypes().toString());
        logger.info((Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isKgEnabled());
        logger.info((Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isPerMessageAuthenticationEnabled());
        logger.info((Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isUserLevelAuthenticationEnabled());
        logger.info((Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isNonNullUsernamesEnabled());
        logger.info((Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isNullUsernamesEnabled());
        logger.info((Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isAnonymusLoginEnabled());
        logger.info((Object)((GetChannelAuthenticationCapabilitiesResponseData)data).getOemId());
        logger.info((Object)((GetChannelAuthenticationCapabilitiesResponseData)data).getOemData());
        logger.info((Object)"##############################################");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
            logger.info((Object)(">>>> " + resp.getLength()));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        OpenSessionResponseData data2 = null;
        try {
            data2 = (OpenSessionResponseData)Decoder.decode(buffer, new PlainCommandv20Decoder(CipherSuite.getEmpty()), new OpenSession(CipherSuite.getEmpty()));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IPMIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)data2.getMessageTag());
        logger.info((Object)data2.getStatusCode());
        logger.info((Object)data2.getPrivilegeLevel());
        logger.info((Object)data2.getRemoteConsoleSessionId());
        logger.info((Object)data2.getManagedSystemSessionId());
        logger.info((Object)data2.getAuthenticationAlgorithm());
        logger.info((Object)data2.getConfidentialityAlgorithm());
        logger.info((Object)data2.getIntegrityAlgorithm());
        managedSeqNum = data2.getManagedSystemSessionId();
        lock = false;
        logger.info((Object)"---------------------------------------------");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        Rakp1ResponseData data3 = null;
        try {
            data3 = (Rakp1ResponseData)Decoder.decode(buffer, new PlainCommandv20Decoder(CipherSuite.getEmpty()), r1);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IPMIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        r1rd = data3;
        logger.info((Object)data3.getMessageTag());
        logger.info((Object)data3.getStatusCode());
        logger.info((Object)data3.getRemoteConsoleSessionId());
        logger.info((Object)data3.getManagedSystemGuid());
        logger.info((Object)"---------------------------------------------");
        lock = false;
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        Rakp3ResponseData data4 = null;
        try {
            data4 = (Rakp3ResponseData)Decoder.decode(buffer, new PlainCommandv20Decoder(CipherSuite.getEmpty()), new Rakp3(cs, r1, r1rd));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IPMIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)data4.getMessageTag());
        logger.info((Object)data4.getStatusCode());
        logger.info((Object)data4.getConsoleSessionId());
        logger.info((Object)"---------------------------------------------");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        GetChassisStatusResponseData data5 = null;
        try {
            data5 = (GetChassisStatusResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetChassisStatus(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IPMIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)data5.getPowerRestorePolicy());
        logger.info((Object)data5.isPowerControlFault());
        logger.info((Object)data5.isPowerFault());
        logger.info((Object)data5.isInterlock());
        logger.info((Object)data5.isPowerOverload());
        logger.info((Object)data5.isPowerOn());
        logger.info((Object)"________");
        logger.info((Object)data5.wasIpmiPowerOn());
        logger.info((Object)data5.wasPowerFault());
        logger.info((Object)data5.wasInterlock());
        logger.info((Object)data5.wasPowerOverload());
        logger.info((Object)"________");
        logger.info((Object)data5.isChassisIdentifyCommandSupported());
        if (data5.isChassisIdentifyCommandSupported()) {
            logger.info((Object)data5.getChassisIdentifyState());
        }
        logger.info((Object)data5.coolingFaultDetected());
        logger.info((Object)data5.driveFaultDetected());
        logger.info((Object)data5.isFrontPanelLockoutActive());
        logger.info((Object)data5.isChassisIntrusionActive());
        logger.info((Object)"________");
        logger.info((Object)data5.isFrontPanelButtonCapabilitiesSet());
        if (data5.isFrontPanelButtonCapabilitiesSet()) {
            try {
                logger.info((Object)data5.isStandbyButtonDisableAllowed());
                logger.info((Object)data5.isDiagnosticInterruptButtonDisableAllowed());
                logger.info((Object)data5.isResetButtonDisableAllowed());
                logger.info((Object)data5.isPowerOffButtonDisableAllowed());
                logger.info((Object)data5.isStandbyButtonDisabled());
                logger.info((Object)data5.isDiagnosticInterruptButtonDisabled());
                logger.info((Object)data5.isResetButtonDisabled());
                logger.info((Object)data5.isPowerOffButtonDisabled());
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        logger.info((Object)"---------------------------------------------");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        GetSdrRepositoryInfoResponseData data6 = null;
        try {
            data6 = (GetSdrRepositoryInfoResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetSdrRepositoryInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IPMIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)data6.getSdrVersion());
        logger.info((Object)data6.getRecordCount());
        logger.info((Object)data6.getAddTimestamp());
        logger.info((Object)data6.getDelTimestamp());
        logger.info((Object)data6.isReserveSupported());
        logger.info((Object)"---------------------------------------------");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ReserveSdrRepositoryResponseData data7 = null;
        try {
            data7 = (ReserveSdrRepositoryResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new ReserveSdrRepository(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IPMIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)data7.getReservationId());
        reservation = data7.getReservationId();
        logger.info((Object)"<<Received ReserveSdrRepo response");
        lock = false;
        logger.info((Object)"---------------------------------------------");
        while (nextRecId < 65535) {
            SensorRecord rec2;
            resp = new DatagramPacket(new byte[256], 256);
            try {
                this.socket.receive(resp);
                buffer = new byte[resp.getLength()];
                System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            GetSdrResponseData data8 = null;
            try {
                data8 = (GetSdrResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetSdr(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, 0, 0));
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IPMIException e) {
                logger.info((Object)e.getMessage());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvalidKeyException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            SensorRecord record = SensorRecord.populateSensorRecord(data8.getSensorRecordData());
            logger.info((Object)record.toString());
            nextRecId = record instanceof FullSensorRecord ? TypeConverter.byteToInt(((FullSensorRecord)record).getSensorNumber()) : (record instanceof CompactSensorRecord ? TypeConverter.byteToInt(((CompactSensorRecord)record).getSensorNumber()) : -1);
            logger.info((Object)("<<Reading Id " + nextRecId));
            if (record instanceof FullSensorRecord) {
                rec2 = (FullSensorRecord)record;
                logger.info((Object)("*" + ((FullSensorRecord)rec2).getName()));
                logger.info((Object)("Reading type: " + ((FullSensorRecord)rec2).getEventReadingType()));
                logger.info((Object)("Lower critical threshold: " + ((FullSensorRecord)rec2).getLowerCriticalThreshold()));
                logger.info((Object)("Upper critical threshold: " + ((FullSensorRecord)rec2).getUpperCriticalThreshold()));
                logger.info((Object)("Tolerance: +/- " + ((FullSensorRecord)rec2).getTolerance() + " " + ((FullSensorRecord)rec2).getSensorBaseUnit().toString() + (((FullSensorRecord)rec2).getRateUnit() != RateUnit.None ? " per " + (Object)((Object)((FullSensorRecord)rec2).getRateUnit()) : "")));
                logger.info((Object)("Resolution: " + ((FullSensorRecord)rec2).getSensorResolution() + " " + ((FullSensorRecord)rec2).getSensorBaseUnit().toString() + (((FullSensorRecord)rec2).getRateUnit() != RateUnit.None ? " per " + (Object)((Object)((FullSensorRecord)rec2).getRateUnit()) : "")));
            }
            if (record instanceof CompactSensorRecord) {
                rec2 = (CompactSensorRecord)record;
                logger.info((Object)("*" + ((CompactSensorRecord)rec2).getName()));
                logger.info((Object)("Reading type: " + ((CompactSensorRecord)rec2).getEventReadingType()));
                logger.info((Object)("Sensor type: " + (Object)((Object)((CompactSensorRecord)rec2).getSensorType())));
            }
            if (record instanceof FruDeviceLocatorRecord) {
                rec2 = (FruDeviceLocatorRecord)record;
                logger.info((Object)((FruDeviceLocatorRecord)rec2).getName());
                logger.info((Object)((FruDeviceLocatorRecord)rec2).getDeviceType());
                logger.info((Object)("FRU entity ID: " + ((FruDeviceLocatorRecord)rec2).getFruEntityId()));
                logger.info((Object)("FRU access address: " + ((FruDeviceLocatorRecord)rec2).getDeviceAccessAddress()));
                logger.info((Object)("FRU device ID: " + ((FruDeviceLocatorRecord)rec2).getDeviceId()));
                logger.info((Object)("FRU logical: " + ((FruDeviceLocatorRecord)rec2).isLogical()));
            }
            lock = false;
            if (nextRecId > 0) {
                resp = new DatagramPacket(new byte[256], 256);
                try {
                    this.socket.receive(resp);
                    buffer = new byte[resp.getLength()];
                    System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                GetSensorReadingResponseData data9 = null;
                try {
                    data9 = (GetSensorReadingResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetSensorReading(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, 0));
                    if (record instanceof FullSensorRecord) {
                        rec = (FullSensorRecord)record;
                        logger.info((Object)(data9.getSensorReading((FullSensorRecord)rec) + " " + ((FullSensorRecord)rec).getSensorBaseUnit().toString() + (((FullSensorRecord)rec).getRateUnit() != RateUnit.None ? " per " + (Object)((Object)((FullSensorRecord)rec).getRateUnit()) : "")));
                    }
                    if (record instanceof CompactSensorRecord) {
                        rec = (CompactSensorRecord)record;
                        List<ReadingType> events = data9.getStatesAsserted(((CompactSensorRecord)rec).getSensorType(), ((CompactSensorRecord)rec).getEventReadingType());
                        String s = "";
                        for (int i = 0; i < events.size(); ++i) {
                            s = s + (Object)((Object)events.get(i)) + ", ";
                        }
                        logger.info((Object)s);
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (IPMIException e) {
                    logger.info((Object)e.getMessage());
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (InvalidKeyException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            nextRecId = data8.getNextRecordId();
            logger.info((Object)"---------------------------------------------");
            lock = false;
        }
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        GetSelInfoResponseData data10 = null;
        try {
            data10 = (GetSelInfoResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetSelInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IPMIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)data10.getSelVersion());
        logger.info((Object)data10.getEntriesCount());
        logger.info((Object)DateFormat.getInstance().format(data10.getAdditionTimestamp()));
        logger.info((Object)DateFormat.getInstance().format(data10.getEraseTimestamp()));
        logger.info((Object)"---------------------------------------------");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ReserveSelResponseData data11 = null;
        try {
            data11 = (ReserveSelResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new ReserveSel(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IPMIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)data11.getReservationId());
        reservation = data11.getReservationId();
        reservation = 0;
        lock = false;
        logger.info((Object)"---------------------------------------------");
        while (nextRecId < 65535) {
            resp = new DatagramPacket(new byte[256], 256);
            try {
                this.socket.receive(resp);
                buffer = new byte[resp.getLength()];
                System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            GetSelEntryResponseData data12 = null;
            try {
                data12 = (GetSelEntryResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetSelEntry(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, 0, 0));
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IPMIException e) {
                logger.info((Object)e.getMessage());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvalidKeyException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            logger.info((Object)data12.getSelRecord().toString());
            rec = data12.getSelRecord();
            logger.info((Object)("Sensor: " + (Object)((Object)((SelRecord)rec).getSensorType())));
            logger.info((Object)((SelRecord)rec).getTimestamp());
            logger.info((Object)((SelRecord)rec).getEventDirection());
            logger.info((Object)((SelRecord)rec).getEvent());
            nextRecId = data12.getNextRecordId();
            lock = false;
            logger.info((Object)"---------------------------------------------");
        }
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        GetFruInventoryAreaInfoResponseData data13 = null;
        try {
            data13 = (GetFruInventoryAreaInfoResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetFruInventoryAreaInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, 0));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IPMIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)("FRU inventory area size: " + data13.getFruInventoryAreaSize()));
        logger.info((Object)("FRU Unit: " + (Object)((Object)data13.getFruUnit())));
        logger.info((Object)"---------------------------------------------");
        rd = new ArrayList<ReadFruDataResponseData>();
        for (int i = 0; i < fruSize; i += 100) {
            resp = new DatagramPacket(new byte[256], 256);
            try {
                this.socket.receive(resp);
                buffer = new byte[resp.getLength()];
                System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            ReadFruDataResponseData data14 = null;
            try {
                data14 = (ReadFruDataResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new ReadFruData(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, 0, BaseUnit.Bytes, 0, 0));
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IPMIException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvalidKeyException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            rd.add(data14);
            logger.info((Object)data14.getFruData().length);
            logger.info((Object)"---------------------------------------------");
        }
        List<FruRecord> records = ReadFruData.decodeFruData(rd);
        for (FruRecord r : records) {
            if (r instanceof ChassisInfo) {
                ChassisInfo chassisInfo = (ChassisInfo)r;
                logger.info((Object)"Chassis info:");
                logger.info((Object)("Chassis type: " + (Object)((Object)chassisInfo.getChassisType())));
                logger.info((Object)("Chassis part number: " + chassisInfo.getChassisPartNumber()));
                logger.info((Object)("Chassis serial number: " + chassisInfo.getChassisSerialNumber()));
                for (String info : chassisInfo.getCustomChassisInfo()) {
                    logger.info((Object)("Custom chassis info: " + info));
                }
                logger.info((Object)"---------------------------------------------");
                continue;
            }
            if (r instanceof BoardInfo) {
                BoardInfo boardInfo = (BoardInfo)r;
                logger.info((Object)"Board info:");
                logger.info((Object)("Board MFG date: " + boardInfo.getMfgDate().toString()));
                logger.info((Object)("Board manufacturer: " + boardInfo.getBoardManufacturer()));
                logger.info((Object)("Board product name: " + boardInfo.getBoardProductName()));
                logger.info((Object)("Board part number: " + boardInfo.getBoardPartNumber()));
                logger.info((Object)("Board serial number: " + boardInfo.getBoardSerialNumber()));
                for (String info : boardInfo.getCustomBoardInfo()) {
                    logger.info((Object)("Custom board info: " + info));
                }
                logger.info((Object)"---------------------------------------------");
                continue;
            }
            if (!(r instanceof ProductInfo)) continue;
            ProductInfo productInfo = (ProductInfo)r;
            logger.info((Object)"Product info:");
            logger.info((Object)("Product manufacturer: " + productInfo.getManufacturerName()));
            logger.info((Object)("Product product name: " + productInfo.getProductName()));
            logger.info((Object)("Product part number: " + productInfo.getProductModelNumber()));
            logger.info((Object)("Product version: " + productInfo.getProductVersion()));
            logger.info((Object)("Product serial number: " + productInfo.getProductSerialNumber()));
            logger.info((Object)("Product asset tag: " + productInfo.getAssetTag()));
            for (String info : productInfo.getCustomProductInfo()) {
                logger.info((Object)("Custom board info: " + info));
            }
            logger.info((Object)"---------------------------------------------");
        }
    }

    static {
        cs = new CipherSuite(0, 1, 0, 0);
        logger = Logger.getLogger(DecoderRunner.class);
        cssrcv = 16;
        nextRecId = 0;
        fruId = 0;
        fruSize = 528;
    }
}

