/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands;

import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.PlainMessage;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv15Message;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.protocol.encoder.Protocolv20Encoder;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public abstract class IpmiCommandCoder {
    private IpmiVersion ipmiVersion;
    private AuthenticationType authenticationType;
    private CipherSuite cipherSuite;

    public void setIpmiVersion(IpmiVersion ipmiVersion) {
        this.ipmiVersion = ipmiVersion;
    }

    public IpmiVersion getIpmiVersion() {
        return this.ipmiVersion;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setCipherSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public IpmiCommandCoder() {
        this.setSessionParameters(IpmiVersion.V20, CipherSuite.getEmpty(), AuthenticationType.RMCPPlus);
    }

    public IpmiCommandCoder(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        this.setSessionParameters(version, cipherSuite, authenticationType);
    }

    public void setSessionParameters(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        if (version == IpmiVersion.V20 && authenticationType != AuthenticationType.RMCPPlus) {
            throw new IllegalArgumentException("Authentication Type must be RMCPPlus for IPMI v2.0 messages");
        }
        this.setIpmiVersion(version);
        this.setAuthenticationType(authenticationType);
        this.setCipherSuite(cipherSuite);
    }

    public IpmiMessage encodeCommand(int sequenceNumber, int sessionId) throws NoSuchAlgorithmException, InvalidKeyException {
        if (this.getIpmiVersion() == IpmiVersion.V15) {
            Ipmiv15Message message = new Ipmiv15Message();
            message.setAuthenticationType(this.getAuthenticationType());
            message.setSessionID(sessionId);
            message.setSessionSequenceNumber(sequenceNumber);
            message.setPayload(this.preparePayload(sequenceNumber));
            return message;
        }
        Ipmiv20Message message = new Ipmiv20Message(this.getCipherSuite().getConfidentialityAlgorithm());
        message.setAuthenticationType(this.getAuthenticationType());
        message.setSessionID(sessionId);
        message.setSessionSequenceNumber(sequenceNumber);
        message.setPayloadType(PayloadType.Ipmi);
        message.setPayloadAuthenticated(this.getCipherSuite().getIntegrityAlgorithm().getCode() != 0);
        message.setPayloadEncrypted(this.getCipherSuite().getConfidentialityAlgorithm().getCode() != 0);
        message.setPayload(this.preparePayload(sequenceNumber));
        message.setAuthCode(this.getCipherSuite().getIntegrityAlgorithm().generateAuthCode(message.getIntegrityAlgorithmBase(new Protocolv20Encoder())));
        return message;
    }

    public boolean isCommandResponse(IpmiMessage message) {
        if (message.getPayload() instanceof IpmiPayload) {
            if (message.getPayload() instanceof IpmiLanResponse) {
                return ((IpmiLanResponse)message.getPayload()).getCommand() == this.getCommandCode();
            }
            return message.getPayload() instanceof PlainMessage;
        }
        return false;
    }

    public abstract byte getCommandCode();

    public abstract NetworkFunction getNetworkFunction();

    protected abstract IpmiPayload preparePayload(int var1) throws NoSuchAlgorithmException, InvalidKeyException;

    public abstract ResponseData getResponseData(IpmiMessage var1) throws IllegalArgumentException, IPMIException, NoSuchAlgorithmException, InvalidKeyException;

    protected byte encodePrivilegeLevel(PrivilegeLevel privilegeLevel) {
        switch (privilegeLevel) {
            case MaximumAvailable: {
                return 0;
            }
            case Callback: {
                return 1;
            }
            case User: {
                return 2;
            }
            case Operator: {
                return 3;
            }
            case Administrator: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid privilege level");
    }
}

