/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.fru.record;

import com.veraxsystems.vxipmi.coding.commands.fru.record.FruRecord;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BoardInfo
extends FruRecord {
    private Date mfgDate;
    private String boardManufacturer = "";
    private String boardProductName = "";
    private String boardSerialNumber = "";
    private String boardPartNumber = "";
    private byte[] fruFileId = new byte[0];
    private String[] customBoardInfo = new String[0];
    private static Logger logger = Logger.getLogger(BoardInfo.class);

    public BoardInfo(byte[] fruData, int offset) {
        if (fruData[offset] != 1) {
            throw new IllegalArgumentException("Invalid format version");
        }
        int languageCode = TypeConverter.byteToInt(fruData[offset + 2]);
        byte[] buffer = new byte[]{fruData[offset + 3], fruData[offset + 4], fruData[offset + 5], 0};
        DateFormat df = DateFormat.getDateInstance(3, Locale.ENGLISH);
        try {
            this.setMfgDate(new Date(df.parse("01/01/96").getTime() + (long)TypeConverter.littleEndianByteArrayToInt(buffer) * 60000L));
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        int partNumber = TypeConverter.byteToInt(fruData[offset + 6]);
        offset += 7;
        int index = 0;
        ArrayList<String> customInfo = new ArrayList<String>();
        block9: while (partNumber != 193 && offset < fruData.length) {
            int partType = (partNumber & 0xC0) >> 6;
            int partDataLength = partNumber & 0x3F;
            if (partDataLength > 0 && partDataLength + offset < fruData.length) {
                byte[] partNumberData = new byte[partDataLength];
                System.arraycopy(fruData, offset, partNumberData, 0, partDataLength);
                offset += partDataLength;
                switch (index) {
                    case 0: {
                        this.setBoardManufacturer(FruRecord.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                        break;
                    }
                    case 1: {
                        this.setBoardProductName(FruRecord.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                        break;
                    }
                    case 2: {
                        this.setBoardSerialNumber(FruRecord.decodeString(partType, partNumberData, true));
                        break;
                    }
                    case 3: {
                        this.setBoardPartNumber(FruRecord.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                        break;
                    }
                    case 4: {
                        this.setFruFileId(partNumberData);
                        break;
                    }
                    default: {
                        if (partDataLength == 0) {
                            partNumber = TypeConverter.byteToInt(fruData[offset]);
                            ++offset;
                            continue block9;
                        }
                        customInfo.add(FruRecord.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                    }
                }
            }
            partNumber = TypeConverter.byteToInt(fruData[offset]);
            ++offset;
            ++index;
        }
        this.customBoardInfo = new String[customInfo.size()];
        this.customBoardInfo = customInfo.toArray(this.customBoardInfo);
    }

    public Date getMfgDate() {
        return this.mfgDate;
    }

    public void setMfgDate(Date mfgDate) {
        this.mfgDate = mfgDate;
    }

    public String getBoardManufacturer() {
        return this.boardManufacturer;
    }

    public void setBoardManufacturer(String boardManufacturer) {
        this.boardManufacturer = boardManufacturer;
    }

    public String getBoardProductName() {
        return this.boardProductName;
    }

    public void setBoardProductName(String boardProductName) {
        this.boardProductName = boardProductName;
    }

    public String getBoardSerialNumber() {
        return this.boardSerialNumber;
    }

    public void setBoardSerialNumber(String boardSerialNumber) {
        this.boardSerialNumber = boardSerialNumber;
    }

    public String getBoardPartNumber() {
        return this.boardPartNumber;
    }

    public void setBoardPartNumber(String boardPartNumber) {
        this.boardPartNumber = boardPartNumber;
    }

    public byte[] getFruFileId() {
        return this.fruFileId;
    }

    public void setFruFileId(byte[] fruFileId) {
        this.fruFileId = fruFileId;
    }

    public String[] getCustomBoardInfo() {
        return this.customBoardInfo;
    }

    public void setCustomBoardInfo(String[] customBoardInfo) {
        this.customBoardInfo = customBoardInfo;
    }
}

