/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.fru.record;

import org.apache.log4j.Logger;

public enum FruMultiRecordType {
    PowerSupplyInformation(0),
    DcOutput(1),
    OemRecord(192),
    DcLoad(2),
    ManagementAccessRecord(3),
    BaseCompatibilityRecord(4),
    ExtendedCompatibilityRecord(5),
    Unspecified(-1);

    private static final int POWERSUPPLYINFORMATION = 0;
    private static final int DCOUTPUT = 1;
    private static final int OEMRECORD = 192;
    private static final int DCLOAD = 2;
    private static final int MANAGEMENTACCESSRECORD = 3;
    private static final int BASECOMPATIBILITYRECORD = 4;
    private static final int EXTENDEDCOMPATIBILITYRECORD = 5;
    private static final int UNSPECIFIED = -1;
    private int code;
    private static Logger logger;

    private FruMultiRecordType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static FruMultiRecordType parseInt(int value) {
        if (value >= 192) {
            return OemRecord;
        }
        switch (value) {
            case 0: {
                return PowerSupplyInformation;
            }
            case 1: {
                return DcOutput;
            }
            case 2: {
                return DcLoad;
            }
            case 3: {
                return ManagementAccessRecord;
            }
            case 4: {
                return BaseCompatibilityRecord;
            }
            case 5: {
                return ExtendedCompatibilityRecord;
            }
        }
        logger.error((Object)("Invalid value: " + value));
        return Unspecified;
    }

    static {
        logger = Logger.getLogger(FruMultiRecordType.class);
    }
}

