/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.fru.record;

import com.veraxsystems.vxipmi.coding.commands.fru.record.BaseCompatibilityInfo;
import com.veraxsystems.vxipmi.coding.commands.fru.record.DcLoadInfo;
import com.veraxsystems.vxipmi.coding.commands.fru.record.DcOutputInfo;
import com.veraxsystems.vxipmi.coding.commands.fru.record.ExtendedCompatibilityInfo;
import com.veraxsystems.vxipmi.coding.commands.fru.record.FruMultiRecordType;
import com.veraxsystems.vxipmi.coding.commands.fru.record.FruRecord;
import com.veraxsystems.vxipmi.coding.commands.fru.record.ManagementAccessInfo;
import com.veraxsystems.vxipmi.coding.commands.fru.record.OemInfo;
import com.veraxsystems.vxipmi.coding.commands.fru.record.PowerSupplyInfo;
import com.veraxsystems.vxipmi.common.TypeConverter;

public abstract class MultiRecordInfo
extends FruRecord {
    public static MultiRecordInfo populateMultiRecord(byte[] fruData, int offset) {
        MultiRecordInfo recordInfo = null;
        if ((TypeConverter.byteToInt(fruData[offset + 1]) & 0xF) != 2) {
            throw new IllegalArgumentException("Invalid FRU record version");
        }
        FruMultiRecordType recordType = FruMultiRecordType.parseInt(TypeConverter.byteToInt(fruData[offset]));
        int length = TypeConverter.byteToInt(fruData[offset + 2]);
        offset += 5;
        switch (recordType) {
            case PowerSupplyInformation: {
                recordInfo = new PowerSupplyInfo(fruData, offset);
                break;
            }
            case DcOutput: {
                recordInfo = new DcOutputInfo(fruData, offset);
                break;
            }
            case DcLoad: {
                recordInfo = new DcLoadInfo(fruData, offset);
                break;
            }
            case ManagementAccessRecord: {
                recordInfo = new ManagementAccessInfo(fruData, offset, length);
                break;
            }
            case BaseCompatibilityRecord: {
                recordInfo = new BaseCompatibilityInfo(fruData, offset, length);
                break;
            }
            case ExtendedCompatibilityRecord: {
                recordInfo = new ExtendedCompatibilityInfo(fruData, offset, length);
                break;
            }
            case OemRecord: {
                recordInfo = new OemInfo(fruData, offset, length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported record type");
            }
        }
        return recordInfo;
    }
}

