/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.fru.record;

import com.veraxsystems.vxipmi.coding.commands.fru.record.FruRecord;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.util.ArrayList;

public class ProductInfo
extends FruRecord {
    private String manufacturerName = "";
    private String productName = "";
    private String productModelNumber = "";
    private String productVersion = "";
    private String productSerialNumber = "";
    private String assetTag = "";
    private byte[] fruFileId = new byte[0];
    private String[] customProductInfo = new String[0];

    public ProductInfo(byte[] fruData, int offset) {
        if (fruData[offset] != 1) {
            throw new IllegalArgumentException("Invalid format version");
        }
        int languageCode = TypeConverter.byteToInt(fruData[offset + 2]);
        int partNumber = TypeConverter.byteToInt(fruData[offset + 3]);
        offset += 4;
        int index = 0;
        ArrayList<String> customInfo = new ArrayList<String>();
        block9: while (partNumber != 193 && offset < fruData.length) {
            int partType = (partNumber & 0xC0) >> 6;
            int partDataLength = partNumber & 0x3F;
            if (partDataLength > 0 && partDataLength + offset < fruData.length) {
                byte[] partNumberData = new byte[partDataLength];
                System.arraycopy(fruData, offset, partNumberData, 0, partDataLength);
                offset += partDataLength;
                switch (index) {
                    case 0: {
                        this.setManufacturerName(FruRecord.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                        break;
                    }
                    case 1: {
                        this.setProductName(FruRecord.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                        break;
                    }
                    case 2: {
                        this.setProductModelNumber(FruRecord.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                        break;
                    }
                    case 3: {
                        this.setProductVersion(FruRecord.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                        break;
                    }
                    case 4: {
                        this.setProductSerialNumber(FruRecord.decodeString(partType, partNumberData, true));
                        break;
                    }
                    case 5: {
                        this.setAssetTag(FruRecord.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                        break;
                    }
                    case 6: {
                        this.setFruFileId(partNumberData);
                        break;
                    }
                    default: {
                        if (partDataLength == 0) {
                            partNumber = TypeConverter.byteToInt(fruData[offset]);
                            ++offset;
                            continue block9;
                        }
                        customInfo.add(FruRecord.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                    }
                }
            }
            partNumber = TypeConverter.byteToInt(fruData[offset]);
            ++offset;
            ++index;
        }
        this.customProductInfo = new String[customInfo.size()];
        this.customProductInfo = customInfo.toArray(this.customProductInfo);
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductModelNumber() {
        return this.productModelNumber;
    }

    public void setProductModelNumber(String productModelNumber) {
        this.productModelNumber = productModelNumber;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setProductSerialNumber(String productSerialNumber) {
        this.productSerialNumber = productSerialNumber;
    }

    public String getProductSerialNumber() {
        return this.productSerialNumber;
    }

    public String getAssetTag() {
        return this.assetTag;
    }

    public void setAssetTag(String assetTag) {
        this.assetTag = assetTag;
    }

    public byte[] getFruFileId() {
        return this.fruFileId;
    }

    public void setFruFileId(byte[] fruFileId) {
        this.fruFileId = fruFileId;
    }

    public String[] getCustomProductInfo() {
        return this.customProductInfo;
    }

    public void setCustomProductInfo(String[] customProductInfo) {
        this.customProductInfo = customProductInfo;
    }
}

