/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.sdr;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.sdr.GetSdrRepositoryInfoResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class GetSdrRepositoryInfo
extends IpmiCommandCoder {
    public GetSdrRepositoryInfo(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        super(version, cipherSuite, authenticationType);
    }

    @Override
    public byte getCommandCode() {
        return 32;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.StorageRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), null, TypeConverter.intToByte(sequenceNumber % 64));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IllegalArgumentException, IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get SDR Repository Info command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw == null || raw.length != 14) {
            throw new IllegalArgumentException("Invalid response payload length");
        }
        GetSdrRepositoryInfoResponseData responseData = new GetSdrRepositoryInfoResponseData();
        responseData.setSdrVersion(TypeConverter.littleEndianBcdByteToInt(raw[0]));
        byte[] buffer = new byte[]{raw[1], raw[2], 0, 0};
        responseData.setRecordCount(TypeConverter.littleEndianByteArrayToInt(buffer));
        System.arraycopy(raw, 5, buffer, 0, 4);
        responseData.setAddTimestamp(TypeConverter.littleEndianByteArrayToInt(buffer));
        System.arraycopy(raw, 9, buffer, 0, 4);
        responseData.setDelTimestamp(TypeConverter.littleEndianByteArrayToInt(buffer));
        responseData.setReserveSupported((TypeConverter.byteToInt(raw[13]) & 2) != 0);
        return responseData;
    }
}

