/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.sdr;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.sdr.GetSensorReadingResponseData;
import com.veraxsystems.vxipmi.coding.commands.sdr.SensorState;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class GetSensorReading
extends IpmiCommandCoder {
    private final byte sensorId;

    public GetSensorReading(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType, int sensorId) {
        super(version, cipherSuite, authenticationType);
        this.sensorId = TypeConverter.intToByte(sensorId);
    }

    @Override
    public byte getCommandCode() {
        return 45;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.SensorRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] payloadData = new byte[]{this.sensorId};
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), payloadData, TypeConverter.intToByte(sequenceNumber % 64));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IllegalArgumentException, IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        int i;
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get Sensor Reading command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        GetSensorReadingResponseData responseData = new GetSensorReadingResponseData();
        responseData.setSensorReading(raw[0]);
        responseData.setSensorStateValid((TypeConverter.byteToInt(raw[1]) & 0x20) == 0);
        if (raw.length > 2) {
            responseData.setSensorState(SensorState.parseInt(TypeConverter.byteToInt(raw[2]) & 0x3F));
        }
        boolean[] states = null;
        states = raw.length > 3 ? new boolean[16] : new boolean[8];
        if (raw.length > 2) {
            for (i = 0; i < 8; ++i) {
                states[i] = (TypeConverter.byteToInt(raw[2]) & 1 << i) != 0;
            }
        }
        if (raw.length > 3) {
            for (i = 0; i < 7; ++i) {
                states[i + 8] = (TypeConverter.byteToInt(raw[3]) & 1 << i) != 0;
            }
            states[15] = false;
        }
        responseData.setStatesAsserted(states);
        return responseData;
    }
}

