/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.sdr.record;

import com.veraxsystems.vxipmi.coding.commands.sdr.record.SensorType;
import org.apache.log4j.Logger;

public enum ReadingType {
    FruInactive(2912001),
    SlotConnectorIdentifyStatusAsserted(2191105),
    HardReset(1928961),
    FruLatchOpen(1339139),
    FruActivationRequested(2912002),
    SlotConnectorDeviceInstalled(2191106),
    WarmReset(1928962),
    FruActivationInProgress(2912003),
    SlotConnectorReadyForDeviceInstallation(2191107),
    PxeBootRequested(1928963),
    FruActive(2912004),
    InvalidUsernameOrPassword(2780930),
    SlotConnectorReadyForDeviceRemoval(2191108),
    AutomaticBootToDiagnostic(1928964),
    FruDeactivationRequested(2912005),
    InvalidPasswordDisable(2780931),
    EntityPresent(2453248),
    SlotPowerOff(2191109),
    SoftwareInitiatedHardReset(1928965),
    FruDeactivationInProgress(2912006),
    SensorFailure(2649860),
    EntityAbsent(2453249),
    SoftwareInitiatedWarmReset(1928966),
    FruCommunicationLost(2912007),
    FruFailure(2649861),
    SystemRestart(1928967),
    StateDeasserted(768),
    SystemFirmwareError(1011456),
    StateAsserted(769),
    SystemFirmwareHang(1011457),
    SystemFirmwareProgress(1011458),
    HardwareChangeDetected(2846464),
    Frb1BistFailure(487170),
    FirmwareOrSoftwareChangeDetected(2846465),
    Frb2HangInPostFailure(487171),
    HardwareIncompatibilityDetected(2846466),
    Frb3ProcessorStartupFailure(487172),
    FirmwareOrSoftwareIncompatibilityDetected(2846467),
    DrivePresence(880384),
    ConfigurationError(487173),
    InvalidOrUnsupportedHardware(2846468),
    DriveFault(880385),
    UncorrectableCpuComplexError(487174),
    InvalidOrUnsupportedFirmwareOrSoftware(2846469),
    PredictiveFailure(880386),
    ProcessorPresenceDetected(487175),
    HotSpare(880387),
    ProcessorDisabled(487176),
    ConsistencyOrParityCheckInProgress(880388),
    TerminatorPresenceDetected(487177),
    SecureModeViolationAttempt(421632),
    OsGracefulStop(2125570),
    InCriticalArray(880389),
    ProcessorAutomaticallyThrottled(487178),
    PreBootUserPasswordViolation(421633),
    OsGracefulShutdown(2125571),
    MachineCheckException(487179),
    PreBootSetupPasswordViolation(421634),
    SoftOsShutdown(2125572),
    PreBootNetworkPasswordViolation(421635),
    LANHeartbeatLost(2584320),
    AgentNotResponding(2125573),
    OtherPreBootPasswordViolation(421636),
    LANHeartbeat(2584321),
    OutOfBandAccessPasswordViolation(421637),
    Current(225024),
    DeviceAbsent(2048),
    Parity(814850),
    DevicePresent(2049),
    MemoryScrubFailed(814851),
    MemoryDeviceDisabled(814852),
    CorrectableEccOtherCorrectableMemoryErrorLoggingLimitReached(814853),
    MemoryPresenceDetected(814854),
    MemoryConfigurationError(814855),
    SpareMemoryUnit(814856),
    MemoryAutomaticallyThrottled(814857),
    MemoryCriticalOvertemperature(814858),
    SystemReconfigured(1208064),
    OemSystemBootEvent(1208065),
    ABootCompleted(2060032),
    UndeterminedSystemHardwareFailure(1208066),
    TransitionToRunning(2560),
    CBootCompleted(2060033),
    EntryAddedToAuxiliaryLog(1208067),
    TransitionToInTest(2561),
    PxeBootCompleted(2060034),
    PefAction(1208068),
    TransitionToPowerOff(2562),
    DiagnosticBootCompleted(2060035),
    TimestampClockSynch(1208069),
    TransitionToOnLine(2563),
    CdRomBootCompleted(2060036),
    BootSourceSelectionTimeout(1994500),
    PowerSupplyConfigurationError(552710),
    TransitionToOffLine(2564),
    TimerExpired(2322176),
    RomBootCompleted(2060037),
    TransitionToOffDuty(2565),
    TimerHardReset(2322177),
    BootCompleted(2060038),
    PredictiveFailureDeasserted(1024),
    TransitionToDegraded(2566),
    TimerPowerDown(2322178),
    AcpiS5EnteredByOverride(2256650),
    LANLeashLost(356100),
    Predictive(1025),
    TransitionToPowerSave(2567),
    TimerPowerCycle(2322179),
    AcpiLegacyOnState(2256651),
    PowerOffOrDown(618240),
    UnauthorizedDock(356101),
    InstallError(2568),
    AcpiLegacyOffState(2256652),
    PowerCycle(618241),
    FANAreaIntrusion(356102),
    FullyRedundant(2816),
    CableInterconnectConnected(1797888),
    PowerDown240V(618242),
    RedundancyLost(2817),
    AcpiUnknown(2256654),
    CableInterconnectConfigurationError(1797889),
    InterlockPowerDown(618243),
    RedundancyDegraded(2818),
    BatteryLow(2715392),
    PowerInputLost(618244),
    NonRedundant_SufficientResourcesFromRedundant(2819),
    BatteryFailed(2715393),
    PowerUnitSoftPowerControlFailure(618245),
    Voltage(159488),
    BatteryPresenceDetected(2715394),
    PowerUnitFailure(618246),
    PowerUnitPredictiveFailure(618247),
    BusFatalError(1273610),
    CorrectableMemoryErrorLoggingDisabled(1076992),
    BusDegraded(1273611),
    EventTypeLoggingDisabled(1076993),
    LogAreaReset(1076994),
    TransitionToOK(1792),
    AllEventLoggingDisabled(1076995),
    TransitionToNonCriticalFromOK(1793),
    FruServiceRequestButtonPressed(1339140),
    SelFull(1076996),
    TransitionToCriticalFromLessSevere(1794),
    SelAlmostFull(1076997),
    TransitionToNonRecoverableFromLessSevere(1795),
    CorrectableMachineCheckErrorLoggingDisabled(1076998),
    TransitionToNonCriticalFromMoreSevere(1796),
    TransitionToCriticalFromNonRecoverable(1797),
    SlotConnectorDeviceRemovalRequest(2191110),
    TransitionToNonRecoverable(1798),
    EntityDisabled(2453250),
    InterlockAsserted(2191111),
    Monitor(1799),
    SlotDisabled(2191112),
    SlotHoldsSpareDevice(2191113),
    PlatformGeneratedPage(2387712),
    PlatformGeneratedLanAlert(2387713),
    PlatformEventTrapGenerated(2387714),
    PlatformGeneratedSnmpTrap(2387715),
    SessionActivated(2780928),
    SensorAccessUnavailable(2649856),
    SessionDeactivated(2780929),
    ControllerAccessUnavailable(2649857),
    ManagementControllerOffLine(2649858),
    SuccessfulHardwareChangeDetected(2846470),
    ManagementControllerUnavailable(2649859),
    SuccessfulSoftwareOrFWChangeDetected(2846471),
    InFailedArray(880390),
    RebuildRemapInProgress(880391),
    CorrectableMachineCheckError(487180),
    RebuildRemapAborted(880392),
    Ierr(487168),
    ChipsetSoftPowerControlFailure(1666816),
    ProcessorThermalTrip(487169),
    ChipsetThermalTrip(1666817),
    D0PowerState(3072),
    D1PowerState(3073),
    Temperature(93952),
    D2PowerState(3074),
    D3PowerState(3075),
    CriticalStopDuringOsLoad(2125568),
    RunTimeCriticalStop(2125569),
    DeviceDisabled(2304),
    DeviceEnabled(2305),
    CorrectableEcc(814848),
    UncorrectableECC(814849),
    LimitNotExceeded(1280),
    LimitExceeded(1281),
    AcpiS0G0Working(2256640),
    AcpiS1SleepingProcessorContextMaintained(2256641),
    PowerSupplyPresenceDetected(552704),
    AcpiS2SleepingProcessorContextLost(2256642),
    PowerSupplyFailureDetected(552705),
    TimerInterrupt(2322184),
    AcpiS3SleepingProcessorContextLostMemoryRetained(2256643),
    PowerSupplyPredictiveFailure(552706),
    Fan(290560),
    NonRedundant_SufficientResourcesFromInsufficientResources(2820),
    AcpiS4NonVolatileSleep(2256644),
    PowerSupplyInputLost(552707),
    NonRedundant_InsufficientResources(2821),
    AcpiS5G2SoftOff(2256645),
    PowerSupplyInputLostOrOutOfRange(552708),
    RedundancyDegradedFromFullyRedundant(2822),
    PerformanceMet(1536),
    AcpiS4S5SoftOffStateUndetermined(2256646),
    PowerSupplyInputOutOfRange(552709),
    RedundancyDegradedFromNonRedundant(2823),
    PerformanceLags(1537),
    AcpiG3MechanicalOff(2256647),
    AcpiSleepingInS1S2OrS3(2256648),
    AcpiG1Sleeping(2256649),
    FrontPanelInterrupt(1273600),
    Informational(1800),
    NoBootableMedia(1994496),
    BusTimeout(1273601),
    NonBootableDisketteLeftInDrive(1994497),
    IoChannelCheckNmi(1273602),
    PxeServerNotFound(1994498),
    Software(1273603),
    InvalidBootSector(1994499),
    PciPErr(1273604),
    GeneralChassisIntrusion(356096),
    TransitionToIdle(512),
    PciSErr(1273605),
    DriveBayIntrusion(356097),
    TransitionToActive(513),
    EisaFailSafeTimeout(1273606),
    IoCardAreaIntrusion(356098),
    TransitionToBusy(514),
    BusCorrectableError(1273607),
    ProcessorAreaIntrusion(356099),
    BusUncorrectableError(1273608),
    FatalNmi(1273609),
    PowerButtonPressed(1339136),
    SleepButtonPressed(1339137),
    FruNotInstalled(2912000),
    SlotConnectorFaultStatusAsserted(2191104),
    PowerUp(1928960),
    ResetButtonPressed(1339138),
    LowerNonCriticalGoingLow(256),
    LowerNonCriticalGoingHigh(257),
    LowerCriticalGoingLow(258),
    LowerCriticalGoingHigh(259),
    LowerNonRecoverableGoingLow(260),
    LowerNonRecoverableGoingHigh(261),
    UpperNonCriticalGoingLow(262),
    UpperNonCriticalGoingHigh(263),
    UpperCriticalGoingLow(264),
    UpperCriticalGoingHigh(265),
    UpperNonRecoverableGoingLow(266),
    UpperNonRecoverableGoingHigh(267),
    UnknownOEMEvent(192),
    CoolingDevice(683776),
    OtherUnitsBasedSensor(749312),
    PostMemoryResize(945920),
    ModuleBoard(1404672),
    MicrocontrollerCoprocessor(1470208),
    AddInCard(1535744),
    Chassis(1601280),
    OtherFru(1732352),
    Terminator(1863424),
    MonitorAsicIc(2518784),
    Unknown(0);

    private static final int LOWERNONCRITICALGOINGLOW = 256;
    private static final int LOWERNONCRITICALGOINGHIGH = 257;
    private static final int LOWERCRITICALGOINGLOW = 258;
    private static final int LOWERCRITICALGOINGHIGH = 259;
    private static final int LOWERNONRECOVERABLEGOINGLOW = 260;
    private static final int LOWERNONRECOVERABLEGOINGHIGH = 261;
    private static final int UPPERNONCRITICALGOINGLOW = 262;
    private static final int UPPERNONCRITICALGOINGHIGH = 263;
    private static final int UPPERCRITICALGOINGLOW = 264;
    private static final int UPPERCRITICALGOINGHIGH = 265;
    private static final int UPPERNONRECOVERABLEGOINGLOW = 266;
    private static final int UPPERNONRECOVERABLEGOINGHIGH = 267;
    private static final int FRUINACTIVE = 2912001;
    private static final int SLOTCONNECTORIDENTIFYSTATUSASSERTED = 2191105;
    private static final int HARDRESET = 1928961;
    private static final int FRULATCHOPEN = 1339139;
    private static final int FRUACTIVATIONREQUESTED = 2912002;
    private static final int SLOTCONNECTORDEVICEINSTALLED = 2191106;
    private static final int WARMRESET = 1928962;
    private static final int FRUACTIVATIONINPROGRESS = 2912003;
    private static final int SLOTCONNECTORREADYFORDEVICEINSTALLATION = 2191107;
    private static final int PXEBOOTREQUESTED = 1928963;
    private static final int FRUACTIVE = 2912004;
    private static final int INVALIDUSERNAMEORPASSWORD = 2780930;
    private static final int SLOTCONNECTORREADYFORDEVICEREMOVAL = 2191108;
    private static final int AUTOMATICBOOTTODIAGNOSTIC = 1928964;
    private static final int FRUDEACTIVATIONREQUESTED = 2912005;
    private static final int INVALIDPASSWORDDISABLE = 2780931;
    private static final int ENTITYPRESENT = 2453248;
    private static final int SLOTPOWEROFF = 2191109;
    private static final int SOFTWAREINITIATEDHARDRESET = 1928965;
    private static final int FRUDEACTIVATIONINPROGRESS = 2912006;
    private static final int SENSORFAILURE = 2649860;
    private static final int ENTITYABSENT = 2453249;
    private static final int SOFTWAREINITIATEDWARMRESET = 1928966;
    private static final int FRUCOMMUNICATIONLOST = 2912007;
    private static final int FRUFAILURE = 2649861;
    private static final int SYSTEMRESTART = 1928967;
    private static final int STATEDEASSERTED = 768;
    private static final int SYSTEMFIRMWAREERROR = 1011456;
    private static final int STATEASSERTED = 769;
    private static final int SYSTEMFIRMWAREHANG = 1011457;
    private static final int SYSTEMFIRMWAREPROGRESS = 1011458;
    private static final int HARDWARECHANGEDETECTED = 2846464;
    private static final int FRB1BISTFAILURE = 487170;
    private static final int FIRMWAREORSOFTWARECHANGEDETECTED = 2846465;
    private static final int FRB2HANGINPOSTFAILURE = 487171;
    private static final int HARDWAREINCOMPATIBILITYDETECTED = 2846466;
    private static final int FRB3PROCESSORSTARTUPFAILURE = 487172;
    private static final int FIRMWAREORSOFTWAREINCOMPATIBILITYDETECTED = 2846467;
    private static final int DRIVEPRESENCE = 880384;
    private static final int CONFIGURATIONERROR = 487173;
    private static final int INVALIDORUNSUPPORTEDHARDWARE = 2846468;
    private static final int DRIVEFAULT = 880385;
    private static final int UNCORRECTABLECPUCOMPLEXERROR = 487174;
    private static final int INVALIDORUNSUPPORTEDFIRMWAREORSOFTWARE = 2846469;
    private static final int PREDICTIVEFAILURE = 880386;
    private static final int PROCESSORPRESENCEDETECTED = 487175;
    private static final int HOTSPARE = 880387;
    private static final int PROCESSORDISABLED = 487176;
    private static final int CONSISTENCYORPARITYCHECKINPROGRESS = 880388;
    private static final int TERMINATORPRESENCEDETECTED = 487177;
    private static final int SECUREMODEVIOLATIONATTEMPT = 421632;
    private static final int OSGRACEFULSTOP = 2125570;
    private static final int INCRITICALARRAY = 880389;
    private static final int PROCESSORAUTOMATICALLYTHROTTLED = 487178;
    private static final int PREBOOTUSERPASSWORDVIOLATION = 421633;
    private static final int OSGRACEFULSHUTDOWN = 2125571;
    private static final int MACHINECHECKEXCEPTION = 487179;
    private static final int PREBOOTSETUPPASSWORDVIOLATION = 421634;
    private static final int SOFTOSSHUTDOWN = 2125572;
    private static final int PREBOOTNETWORKPASSWORDVIOLATION = 421635;
    private static final int LANHEARTBEATLOST = 2584320;
    private static final int AGENTNOTRESPONDING = 2125573;
    private static final int OTHERPREBOOTPASSWORDVIOLATION = 421636;
    private static final int LANHEARTBEAT = 2584321;
    private static final int OUTOFBANDACCESSPASSWORDVIOLATION = 421637;
    private static final int CURRENT = 225024;
    private static final int DEVICEABSENT = 2048;
    private static final int PARITY = 814850;
    private static final int DEVICEPRESENT = 2049;
    private static final int MEMORYSCRUBFAILED = 814851;
    private static final int MEMORYDEVICEDISABLED = 814852;
    private static final int CORRECTABLEECCOTHERCORRECTABLEMEMORYERRORLOGGINGLIMITREACHED = 814853;
    private static final int MEMORYPRESENCEDETECTED = 814854;
    private static final int MEMORYCONFIGURATIONERROR = 814855;
    private static final int SPAREMEMORYUNIT = 814856;
    private static final int MEMORYAUTOMATICALLYTHROTTLED = 814857;
    private static final int MEMORYCRITICALOVERTEMPERATURE = 814858;
    private static final int SYSTEMRECONFIGURED = 1208064;
    private static final int OEMSYSTEMBOOTEVENT = 1208065;
    private static final int ABOOTCOMPLETED = 2060032;
    private static final int UNDETERMINEDSYSTEMHARDWAREFAILURE = 1208066;
    private static final int TRANSITIONTORUNNING = 2560;
    private static final int CBOOTCOMPLETED = 2060033;
    private static final int ENTRYADDEDTOAUXILIARYLOG = 1208067;
    private static final int TRANSITIONTOINTEST = 2561;
    private static final int PXEBOOTCOMPLETED = 2060034;
    private static final int PEFACTION = 1208068;
    private static final int TRANSITIONTOPOWEROFF = 2562;
    private static final int DIAGNOSTICBOOTCOMPLETED = 2060035;
    private static final int TIMESTAMPCLOCKSYNCH = 1208069;
    private static final int TRANSITIONTOONLINE = 2563;
    private static final int CDROMBOOTCOMPLETED = 2060036;
    private static final int BOOTSOURCESELECTIONTIMEOUT = 1994500;
    private static final int POWERSUPPLYCONFIGURATIONERROR = 552710;
    private static final int TRANSITIONTOOFFLINE = 2564;
    private static final int TIMEREXPIRED = 2322176;
    private static final int ROMBOOTCOMPLETED = 2060037;
    private static final int TRANSITIONTOOFFDUTY = 2565;
    private static final int TIMERHARDRESET = 2322177;
    private static final int BOOTCOMPLETED = 2060038;
    private static final int PREDICTIVEFAILUREDEASSERTED = 1024;
    private static final int TRANSITIONTODEGRADED = 2566;
    private static final int TIMERPOWERDOWN = 2322178;
    private static final int ACPIS5ENTEREDBYOVERRIDE = 2256650;
    private static final int LANLEASHLOST = 356100;
    private static final int PREDICTIVE = 1025;
    private static final int TRANSITIONTOPOWERSAVE = 2567;
    private static final int TIMERPOWERCYCLE = 2322179;
    private static final int ACPILEGACYONSTATE = 2256651;
    private static final int POWEROFFORDOWN = 618240;
    private static final int UNAUTHORIZEDDOCK = 356101;
    private static final int INSTALLERROR = 2568;
    private static final int ACPILEGACYOFFSTATE = 2256652;
    private static final int POWERCYCLE = 618241;
    private static final int FANAREAINTRUSION = 356102;
    private static final int FULLYREDUNDANT = 2816;
    private static final int CABLEINTERCONNECTCONNECTED = 1797888;
    private static final int POWERDOWN240V = 618242;
    private static final int REDUNDANCYLOST = 2817;
    private static final int ACPIUNKNOWN = 2256654;
    private static final int CABLEINTERCONNECTCONFIGURATIONERROR = 1797889;
    private static final int INTERLOCKPOWERDOWN = 618243;
    private static final int REDUNDANCYDEGRADED = 2818;
    private static final int BATTERYLOW = 2715392;
    private static final int POWERINPUTLOST = 618244;
    private static final int NONREDUNDANT_SUFFICIENTRESOURCESFROMREDUNDANT = 2819;
    private static final int BATTERYFAILED = 2715393;
    private static final int POWERUNITSOFTPOWERCONTROLFAILURE = 618245;
    private static final int VOLTAGE = 159488;
    private static final int BATTERYPRESENCEDETECTED = 2715394;
    private static final int POWERUNITFAILURE = 618246;
    private static final int POWERUNITPREDICTIVEFAILURE = 618247;
    private static final int BUSFATALERROR = 1273610;
    private static final int CORRECTABLEMEMORYERRORLOGGINGDISABLED = 1076992;
    private static final int BUSDEGRADED = 1273611;
    private static final int EVENTTYPELOGGINGDISABLED = 1076993;
    private static final int LOGAREARESET = 1076994;
    private static final int TRANSITIONTOOK = 1792;
    private static final int ALLEVENTLOGGINGDISABLED = 1076995;
    private static final int TRANSITIONTONONCRITICALFROMOK = 1793;
    private static final int FRUSERVICEREQUESTBUTTONPRESSED = 1339140;
    private static final int SELFULL = 1076996;
    private static final int TRANSITIONTOCRITICALFROMLESSSEVERE = 1794;
    private static final int SELALMOSTFULL = 1076997;
    private static final int TRANSITIONTONONRECOVERABLEFROMLESSSEVERE = 1795;
    private static final int CORRECTABLEMACHINECHECKERRORLOGGINGDISABLED = 1076998;
    private static final int TRANSITIONTONONCRITICALFROMMORESEVERE = 1796;
    private static final int TRANSITIONTOCRITICALFROMNONRECOVERABLE = 1797;
    private static final int SLOTCONNECTORDEVICEREMOVALREQUEST = 2191110;
    private static final int TRANSITIONTONONRECOVERABLE = 1798;
    private static final int ENTITYDISABLED = 2453250;
    private static final int INTERLOCKASSERTED = 2191111;
    private static final int MONITOR = 1799;
    private static final int SLOTDISABLED = 2191112;
    private static final int SLOTHOLDSSPAREDEVICE = 2191113;
    private static final int PLATFORMGENERATEDPAGE = 2387712;
    private static final int PLATFORMGENERATEDLANALERT = 2387713;
    private static final int PLATFORMEVENTTRAPGENERATED = 2387714;
    private static final int PLATFORMGENERATEDSNMPTRAP = 2387715;
    private static final int SESSIONACTIVATED = 2780928;
    private static final int SENSORACCESSUNAVAILABLE = 2649856;
    private static final int SESSIONDEACTIVATED = 2780929;
    private static final int CONTROLLERACCESSUNAVAILABLE = 2649857;
    private static final int MANAGEMENTCONTROLLEROFFLINE = 2649858;
    private static final int SUCCESSFULHARDWARECHANGEDETECTED = 2846470;
    private static final int MANAGEMENTCONTROLLERUNAVAILABLE = 2649859;
    private static final int SUCCESSFULSOFTWAREORFWCHANGEDETECTED = 2846471;
    private static final int INFAILEDARRAY = 880390;
    private static final int REBUILDREMAPINPROGRESS = 880391;
    private static final int CORRECTABLEMACHINECHECKERROR = 487180;
    private static final int REBUILDREMAPABORTED = 880392;
    private static final int IERR = 487168;
    private static final int CHIPSETSOFTPOWERCONTROLFAILURE = 1666816;
    private static final int PROCESSORTHERMALTRIP = 487169;
    private static final int CHIPSETTHERMALTRIP = 1666817;
    private static final int D0POWERSTATE = 3072;
    private static final int D1POWERSTATE = 3073;
    private static final int TEMPERATURE = 93952;
    private static final int D2POWERSTATE = 3074;
    private static final int D3POWERSTATE = 3075;
    private static final int CRITICALSTOPDURINGOSLOAD = 2125568;
    private static final int RUNTIMECRITICALSTOP = 2125569;
    private static final int DEVICEDISABLED = 2304;
    private static final int DEVICEENABLED = 2305;
    private static final int CORRECTABLEECC = 814848;
    private static final int UNCORRECTABLEECC = 814849;
    private static final int LIMITNOTEXCEEDED = 1280;
    private static final int LIMITEXCEEDED = 1281;
    private static final int ACPIS0G0WORKING = 2256640;
    private static final int ACPIS1SLEEPINGPROCESSORCONTEXTMAINTAINED = 2256641;
    private static final int POWERSUPPLYPRESENCEDETECTED = 552704;
    private static final int ACPIS2SLEEPINGPROCESSORCONTEXTLOST = 2256642;
    private static final int POWERSUPPLYFAILUREDETECTED = 552705;
    private static final int TIMERINTERRUPT = 2322184;
    private static final int ACPIS3SLEEPINGPROCESSORCONTEXTLOSTMEMORYRETAINED = 2256643;
    private static final int POWERSUPPLYPREDICTIVEFAILURE = 552706;
    private static final int FAN = 290560;
    private static final int NONREDUNDANT_SUFFICIENTRESOURCESFROMINSUFFICIENTRESOURCES = 2820;
    private static final int ACPIS4NONVOLATILESLEEP = 2256644;
    private static final int POWERSUPPLYINPUTLOST = 552707;
    private static final int NONREDUNDANT_INSUFFICIENTRESOURCES = 2821;
    private static final int ACPIS5G2SOFTOFF = 2256645;
    private static final int POWERSUPPLYINPUTLOSTOROUTOFRANGE = 552708;
    private static final int REDUNDANCYDEGRADEDFROMFULLYREDUNDANT = 2822;
    private static final int PERFORMANCEMET = 1536;
    private static final int ACPIS4S5SOFTOFFSTATEUNDETERMINED = 2256646;
    private static final int POWERSUPPLYINPUTOUTOFRANGE = 552709;
    private static final int REDUNDANCYDEGRADEDFROMNONREDUNDANT = 2823;
    private static final int PERFORMANCELAGS = 1537;
    private static final int ACPIG3MECHANICALOFF = 2256647;
    private static final int ACPISLEEPINGINS1S2ORS3 = 2256648;
    private static final int ACPIG1SLEEPING = 2256649;
    private static final int FRONTPANELINTERRUPT = 1273600;
    private static final int INFORMATIONAL = 1800;
    private static final int NOBOOTABLEMEDIA = 1994496;
    private static final int BUSTIMEOUT = 1273601;
    private static final int NONBOOTABLEDISKETTELEFTINDRIVE = 1994497;
    private static final int IOCHANNELCHECKNMI = 1273602;
    private static final int PXESERVERNOTFOUND = 1994498;
    private static final int SOFTWARE = 1273603;
    private static final int INVALIDBOOTSECTOR = 1994499;
    private static final int PCIPERR = 1273604;
    private static final int GENERALCHASSISINTRUSION = 356096;
    private static final int TRANSITIONTOIDLE = 512;
    private static final int PCISERR = 1273605;
    private static final int DRIVEBAYINTRUSION = 356097;
    private static final int TRANSITIONTOACTIVE = 513;
    private static final int EISAFAILSAFETIMEOUT = 1273606;
    private static final int IOCARDAREAINTRUSION = 356098;
    private static final int TRANSITIONTOBUSY = 514;
    private static final int BUSCORRECTABLEERROR = 1273607;
    private static final int PROCESSORAREAINTRUSION = 356099;
    private static final int BUSUNCORRECTABLEERROR = 1273608;
    private static final int FATALNMI = 1273609;
    private static final int POWERBUTTONPRESSED = 1339136;
    private static final int SLEEPBUTTONPRESSED = 1339137;
    private static final int FRUNOTINSTALLED = 2912000;
    private static final int SLOTCONNECTORFAULTSTATUSASSERTED = 2191104;
    private static final int POWERUP = 1928960;
    private static final int RESETBUTTONPRESSED = 1339138;
    private static final int UNKNOWNOEM = 192;
    private static final int COOLINGDEVICE = 683776;
    private static final int OTHERUNITSBASEDSENSOR = 749312;
    private static final int POSTMEMORYRESIZE = 945920;
    private static final int MODULEBOARD = 1404672;
    private static final int MICROCONTROLLERCOPROCESSOR = 1470208;
    private static final int ADDINCARD = 1535744;
    private static final int CHASSIS = 1601280;
    private static final int OTHERFRU = 1732352;
    private static final int TERMINATOR = 1863424;
    private static final int MONITORASICIC = 2518784;
    private static final int UNKNOWN = 0;
    private static Logger logger;
    private int code;

    private ReadingType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static ReadingType parseInt(SensorType sensorType, int eventReadingType, int offset) {
        if (sensorType == SensorType.Oem) {
            return UnknownOEMEvent;
        }
        if (eventReadingType == 111 && sensorType.getCode() <= 4) {
            offset = 0;
        }
        int value = eventReadingType << 8 | offset;
        if (eventReadingType == 111) {
            value |= sensorType.getCode() << 16;
        }
        switch (value) {
            case 256: {
                return LowerNonCriticalGoingLow;
            }
            case 257: {
                return LowerNonCriticalGoingHigh;
            }
            case 258: {
                return LowerCriticalGoingLow;
            }
            case 259: {
                return LowerCriticalGoingHigh;
            }
            case 260: {
                return LowerNonRecoverableGoingLow;
            }
            case 261: {
                return LowerNonRecoverableGoingHigh;
            }
            case 262: {
                return UpperNonCriticalGoingLow;
            }
            case 263: {
                return UpperNonCriticalGoingHigh;
            }
            case 264: {
                return UpperCriticalGoingLow;
            }
            case 265: {
                return UpperCriticalGoingHigh;
            }
            case 266: {
                return UpperNonRecoverableGoingLow;
            }
            case 267: {
                return UpperNonRecoverableGoingHigh;
            }
            case 2912001: {
                return FruInactive;
            }
            case 2191105: {
                return SlotConnectorIdentifyStatusAsserted;
            }
            case 1928961: {
                return HardReset;
            }
            case 1339139: {
                return FruLatchOpen;
            }
            case 2912002: {
                return FruActivationRequested;
            }
            case 2191106: {
                return SlotConnectorDeviceInstalled;
            }
            case 1928962: {
                return WarmReset;
            }
            case 2912003: {
                return FruActivationInProgress;
            }
            case 2191107: {
                return SlotConnectorReadyForDeviceInstallation;
            }
            case 1928963: {
                return PxeBootRequested;
            }
            case 2912004: {
                return FruActive;
            }
            case 2780930: {
                return InvalidUsernameOrPassword;
            }
            case 2191108: {
                return SlotConnectorReadyForDeviceRemoval;
            }
            case 1928964: {
                return AutomaticBootToDiagnostic;
            }
            case 2912005: {
                return FruDeactivationRequested;
            }
            case 2780931: {
                return InvalidPasswordDisable;
            }
            case 2453248: {
                return EntityPresent;
            }
            case 2191109: {
                return SlotPowerOff;
            }
            case 1928965: {
                return SoftwareInitiatedHardReset;
            }
            case 2912006: {
                return FruDeactivationInProgress;
            }
            case 2649860: {
                return SensorFailure;
            }
            case 2453249: {
                return EntityAbsent;
            }
            case 1928966: {
                return SoftwareInitiatedWarmReset;
            }
            case 2912007: {
                return FruCommunicationLost;
            }
            case 2649861: {
                return FruFailure;
            }
            case 1928967: {
                return SystemRestart;
            }
            case 768: {
                return StateDeasserted;
            }
            case 1011456: {
                return SystemFirmwareError;
            }
            case 769: {
                return StateAsserted;
            }
            case 1011457: {
                return SystemFirmwareHang;
            }
            case 1011458: {
                return SystemFirmwareProgress;
            }
            case 2846464: {
                return HardwareChangeDetected;
            }
            case 487170: {
                return Frb1BistFailure;
            }
            case 2846465: {
                return FirmwareOrSoftwareChangeDetected;
            }
            case 487171: {
                return Frb2HangInPostFailure;
            }
            case 2846466: {
                return HardwareIncompatibilityDetected;
            }
            case 487172: {
                return Frb3ProcessorStartupFailure;
            }
            case 2846467: {
                return FirmwareOrSoftwareIncompatibilityDetected;
            }
            case 880384: {
                return DrivePresence;
            }
            case 487173: {
                return ConfigurationError;
            }
            case 2846468: {
                return InvalidOrUnsupportedHardware;
            }
            case 880385: {
                return DriveFault;
            }
            case 487174: {
                return UncorrectableCpuComplexError;
            }
            case 2846469: {
                return InvalidOrUnsupportedFirmwareOrSoftware;
            }
            case 880386: {
                return PredictiveFailure;
            }
            case 487175: {
                return ProcessorPresenceDetected;
            }
            case 880387: {
                return HotSpare;
            }
            case 487176: {
                return ProcessorDisabled;
            }
            case 880388: {
                return ConsistencyOrParityCheckInProgress;
            }
            case 487177: {
                return TerminatorPresenceDetected;
            }
            case 421632: {
                return SecureModeViolationAttempt;
            }
            case 2125570: {
                return OsGracefulStop;
            }
            case 880389: {
                return InCriticalArray;
            }
            case 487178: {
                return ProcessorAutomaticallyThrottled;
            }
            case 421633: {
                return PreBootUserPasswordViolation;
            }
            case 2125571: {
                return OsGracefulShutdown;
            }
            case 487179: {
                return MachineCheckException;
            }
            case 421634: {
                return PreBootSetupPasswordViolation;
            }
            case 2125572: {
                return SoftOsShutdown;
            }
            case 421635: {
                return PreBootNetworkPasswordViolation;
            }
            case 2584320: {
                return LANHeartbeatLost;
            }
            case 2125573: {
                return AgentNotResponding;
            }
            case 421636: {
                return OtherPreBootPasswordViolation;
            }
            case 2584321: {
                return LANHeartbeat;
            }
            case 421637: {
                return OutOfBandAccessPasswordViolation;
            }
            case 225024: {
                return Current;
            }
            case 2048: {
                return DeviceAbsent;
            }
            case 814850: {
                return Parity;
            }
            case 2049: {
                return DevicePresent;
            }
            case 814851: {
                return MemoryScrubFailed;
            }
            case 814852: {
                return MemoryDeviceDisabled;
            }
            case 814853: {
                return CorrectableEccOtherCorrectableMemoryErrorLoggingLimitReached;
            }
            case 814854: {
                return MemoryPresenceDetected;
            }
            case 814855: {
                return MemoryConfigurationError;
            }
            case 814856: {
                return SpareMemoryUnit;
            }
            case 814857: {
                return MemoryAutomaticallyThrottled;
            }
            case 814858: {
                return MemoryCriticalOvertemperature;
            }
            case 1208064: {
                return SystemReconfigured;
            }
            case 1208065: {
                return OemSystemBootEvent;
            }
            case 2060032: {
                return ABootCompleted;
            }
            case 1208066: {
                return UndeterminedSystemHardwareFailure;
            }
            case 2560: {
                return TransitionToRunning;
            }
            case 2060033: {
                return CBootCompleted;
            }
            case 1208067: {
                return EntryAddedToAuxiliaryLog;
            }
            case 2561: {
                return TransitionToInTest;
            }
            case 2060034: {
                return PxeBootCompleted;
            }
            case 1208068: {
                return PefAction;
            }
            case 2562: {
                return TransitionToPowerOff;
            }
            case 2060035: {
                return DiagnosticBootCompleted;
            }
            case 1208069: {
                return TimestampClockSynch;
            }
            case 2563: {
                return TransitionToOnLine;
            }
            case 2060036: {
                return CdRomBootCompleted;
            }
            case 1994500: {
                return BootSourceSelectionTimeout;
            }
            case 552710: {
                return PowerSupplyConfigurationError;
            }
            case 2564: {
                return TransitionToOffLine;
            }
            case 2322176: {
                return TimerExpired;
            }
            case 2060037: {
                return RomBootCompleted;
            }
            case 2565: {
                return TransitionToOffDuty;
            }
            case 2322177: {
                return TimerHardReset;
            }
            case 2060038: {
                return BootCompleted;
            }
            case 1024: {
                return PredictiveFailureDeasserted;
            }
            case 2566: {
                return TransitionToDegraded;
            }
            case 2322178: {
                return TimerPowerDown;
            }
            case 2256650: {
                return AcpiS5EnteredByOverride;
            }
            case 356100: {
                return LANLeashLost;
            }
            case 1025: {
                return Predictive;
            }
            case 2567: {
                return TransitionToPowerSave;
            }
            case 2322179: {
                return TimerPowerCycle;
            }
            case 2256651: {
                return AcpiLegacyOnState;
            }
            case 618240: {
                return PowerOffOrDown;
            }
            case 356101: {
                return UnauthorizedDock;
            }
            case 2568: {
                return InstallError;
            }
            case 2256652: {
                return AcpiLegacyOffState;
            }
            case 618241: {
                return PowerCycle;
            }
            case 356102: {
                return FANAreaIntrusion;
            }
            case 2816: {
                return FullyRedundant;
            }
            case 1797888: {
                return CableInterconnectConnected;
            }
            case 618242: {
                return PowerDown240V;
            }
            case 2817: {
                return RedundancyLost;
            }
            case 2256654: {
                return AcpiUnknown;
            }
            case 1797889: {
                return CableInterconnectConfigurationError;
            }
            case 618243: {
                return InterlockPowerDown;
            }
            case 2818: {
                return RedundancyDegraded;
            }
            case 2715392: {
                return BatteryLow;
            }
            case 618244: {
                return PowerInputLost;
            }
            case 2819: {
                return NonRedundant_SufficientResourcesFromRedundant;
            }
            case 2715393: {
                return BatteryFailed;
            }
            case 618245: {
                return PowerUnitSoftPowerControlFailure;
            }
            case 159488: {
                return Voltage;
            }
            case 2715394: {
                return BatteryPresenceDetected;
            }
            case 618246: {
                return PowerUnitFailure;
            }
            case 618247: {
                return PowerUnitPredictiveFailure;
            }
            case 1273610: {
                return BusFatalError;
            }
            case 1076992: {
                return CorrectableMemoryErrorLoggingDisabled;
            }
            case 1273611: {
                return BusDegraded;
            }
            case 1076993: {
                return EventTypeLoggingDisabled;
            }
            case 1076994: {
                return LogAreaReset;
            }
            case 1792: {
                return TransitionToOK;
            }
            case 1076995: {
                return AllEventLoggingDisabled;
            }
            case 1793: {
                return TransitionToNonCriticalFromOK;
            }
            case 1339140: {
                return FruServiceRequestButtonPressed;
            }
            case 1076996: {
                return SelFull;
            }
            case 1794: {
                return TransitionToCriticalFromLessSevere;
            }
            case 1076997: {
                return SelAlmostFull;
            }
            case 1795: {
                return TransitionToNonRecoverableFromLessSevere;
            }
            case 1076998: {
                return CorrectableMachineCheckErrorLoggingDisabled;
            }
            case 1796: {
                return TransitionToNonCriticalFromMoreSevere;
            }
            case 1797: {
                return TransitionToCriticalFromNonRecoverable;
            }
            case 2191110: {
                return SlotConnectorDeviceRemovalRequest;
            }
            case 1798: {
                return TransitionToNonRecoverable;
            }
            case 2453250: {
                return EntityDisabled;
            }
            case 2191111: {
                return InterlockAsserted;
            }
            case 1799: {
                return Monitor;
            }
            case 2191112: {
                return SlotDisabled;
            }
            case 2191113: {
                return SlotHoldsSpareDevice;
            }
            case 2387712: {
                return PlatformGeneratedPage;
            }
            case 2387713: {
                return PlatformGeneratedLanAlert;
            }
            case 2387714: {
                return PlatformEventTrapGenerated;
            }
            case 2387715: {
                return PlatformGeneratedSnmpTrap;
            }
            case 2780928: {
                return SessionActivated;
            }
            case 2649856: {
                return SensorAccessUnavailable;
            }
            case 2780929: {
                return SessionDeactivated;
            }
            case 2649857: {
                return ControllerAccessUnavailable;
            }
            case 2649858: {
                return ManagementControllerOffLine;
            }
            case 2846470: {
                return SuccessfulHardwareChangeDetected;
            }
            case 2649859: {
                return ManagementControllerUnavailable;
            }
            case 2846471: {
                return SuccessfulSoftwareOrFWChangeDetected;
            }
            case 880390: {
                return InFailedArray;
            }
            case 880391: {
                return RebuildRemapInProgress;
            }
            case 487180: {
                return CorrectableMachineCheckError;
            }
            case 880392: {
                return RebuildRemapAborted;
            }
            case 487168: {
                return Ierr;
            }
            case 1666816: {
                return ChipsetSoftPowerControlFailure;
            }
            case 487169: {
                return ProcessorThermalTrip;
            }
            case 1666817: {
                return ChipsetThermalTrip;
            }
            case 3072: {
                return D0PowerState;
            }
            case 3073: {
                return D1PowerState;
            }
            case 93952: {
                return Temperature;
            }
            case 3074: {
                return D2PowerState;
            }
            case 3075: {
                return D3PowerState;
            }
            case 2125568: {
                return CriticalStopDuringOsLoad;
            }
            case 2125569: {
                return RunTimeCriticalStop;
            }
            case 2304: {
                return DeviceDisabled;
            }
            case 2305: {
                return DeviceEnabled;
            }
            case 814848: {
                return CorrectableEcc;
            }
            case 814849: {
                return UncorrectableECC;
            }
            case 1280: {
                return LimitNotExceeded;
            }
            case 1281: {
                return LimitExceeded;
            }
            case 2256640: {
                return AcpiS0G0Working;
            }
            case 2256641: {
                return AcpiS1SleepingProcessorContextMaintained;
            }
            case 552704: {
                return PowerSupplyPresenceDetected;
            }
            case 2256642: {
                return AcpiS2SleepingProcessorContextLost;
            }
            case 552705: {
                return PowerSupplyFailureDetected;
            }
            case 2322184: {
                return TimerInterrupt;
            }
            case 2256643: {
                return AcpiS3SleepingProcessorContextLostMemoryRetained;
            }
            case 552706: {
                return PowerSupplyPredictiveFailure;
            }
            case 290560: {
                return Fan;
            }
            case 2820: {
                return NonRedundant_SufficientResourcesFromInsufficientResources;
            }
            case 2256644: {
                return AcpiS4NonVolatileSleep;
            }
            case 552707: {
                return PowerSupplyInputLost;
            }
            case 2821: {
                return NonRedundant_InsufficientResources;
            }
            case 2256645: {
                return AcpiS5G2SoftOff;
            }
            case 552708: {
                return PowerSupplyInputLostOrOutOfRange;
            }
            case 2822: {
                return RedundancyDegradedFromFullyRedundant;
            }
            case 1536: {
                return PerformanceMet;
            }
            case 2256646: {
                return AcpiS4S5SoftOffStateUndetermined;
            }
            case 552709: {
                return PowerSupplyInputOutOfRange;
            }
            case 2823: {
                return RedundancyDegradedFromNonRedundant;
            }
            case 1537: {
                return PerformanceLags;
            }
            case 2256647: {
                return AcpiG3MechanicalOff;
            }
            case 2256648: {
                return AcpiSleepingInS1S2OrS3;
            }
            case 2256649: {
                return AcpiG1Sleeping;
            }
            case 1273600: {
                return FrontPanelInterrupt;
            }
            case 1800: {
                return Informational;
            }
            case 1994496: {
                return NoBootableMedia;
            }
            case 1273601: {
                return BusTimeout;
            }
            case 1994497: {
                return NonBootableDisketteLeftInDrive;
            }
            case 1273602: {
                return IoChannelCheckNmi;
            }
            case 1994498: {
                return PxeServerNotFound;
            }
            case 1273603: {
                return Software;
            }
            case 1994499: {
                return InvalidBootSector;
            }
            case 1273604: {
                return PciPErr;
            }
            case 356096: {
                return GeneralChassisIntrusion;
            }
            case 512: {
                return TransitionToIdle;
            }
            case 1273605: {
                return PciSErr;
            }
            case 356097: {
                return DriveBayIntrusion;
            }
            case 513: {
                return TransitionToActive;
            }
            case 1273606: {
                return EisaFailSafeTimeout;
            }
            case 356098: {
                return IoCardAreaIntrusion;
            }
            case 514: {
                return TransitionToBusy;
            }
            case 1273607: {
                return BusCorrectableError;
            }
            case 356099: {
                return ProcessorAreaIntrusion;
            }
            case 1273608: {
                return BusUncorrectableError;
            }
            case 1273609: {
                return FatalNmi;
            }
            case 1339136: {
                return PowerButtonPressed;
            }
            case 1339137: {
                return SleepButtonPressed;
            }
            case 2912000: {
                return FruNotInstalled;
            }
            case 2191104: {
                return SlotConnectorFaultStatusAsserted;
            }
            case 1928960: {
                return PowerUp;
            }
            case 1339138: {
                return ResetButtonPressed;
            }
            case 683776: {
                return CoolingDevice;
            }
            case 749312: {
                return OtherUnitsBasedSensor;
            }
            case 945920: {
                return PostMemoryResize;
            }
            case 1404672: {
                return ModuleBoard;
            }
            case 1470208: {
                return MicrocontrollerCoprocessor;
            }
            case 1535744: {
                return AddInCard;
            }
            case 1601280: {
                return Chassis;
            }
            case 1732352: {
                return OtherFru;
            }
            case 1863424: {
                return Terminator;
            }
            case 2518784: {
                return MonitorAsicIc;
            }
        }
        logger.warn((Object)("Invalid value: " + value + " (" + Integer.toHexString(value) + ") for sensor " + (Object)((Object)sensorType)));
        return Unknown;
    }

    static {
        logger = Logger.getLogger(ReadingType.class);
    }
}

