/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.sdr.record;

import com.veraxsystems.vxipmi.coding.commands.sdr.record.CompactSensorRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.DeviceRelativeEntityAssiciationRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.EntityAssociationRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.EventOnlyRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.FruDeviceLocatorRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.FullSensorRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.GenericDeviceLocatorRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.ManagementControllerConfirmationRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.ManagementControllerDeviceLocatorRecord;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.OemRecord;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.nio.charset.Charset;

public abstract class SensorRecord {
    private int id;
    private int sdrVersion;
    private byte recordType;
    private int recordLength;

    public static SensorRecord populateSensorRecord(byte[] recordData) throws IllegalArgumentException {
        if (recordData.length < 5) {
            throw new IllegalArgumentException("Record data is too short");
        }
        SensorRecord sensorRecord = null;
        byte recType = recordData[3];
        switch (recType) {
            case 1: {
                sensorRecord = new FullSensorRecord();
                break;
            }
            case 20: {
                throw new IllegalArgumentException("This format is deprecated");
            }
            case 2: {
                sensorRecord = new CompactSensorRecord();
                break;
            }
            case 9: {
                sensorRecord = new DeviceRelativeEntityAssiciationRecord();
                break;
            }
            case 8: {
                sensorRecord = new EntityAssociationRecord();
                break;
            }
            case 3: {
                sensorRecord = new EventOnlyRecord();
                break;
            }
            case 17: {
                sensorRecord = new FruDeviceLocatorRecord();
                break;
            }
            case 16: {
                sensorRecord = new GenericDeviceLocatorRecord();
                break;
            }
            case 19: {
                sensorRecord = new ManagementControllerConfirmationRecord();
                break;
            }
            case 18: {
                sensorRecord = new ManagementControllerDeviceLocatorRecord();
                break;
            }
            case -64: {
                sensorRecord = new OemRecord();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid record type: " + recType);
            }
        }
        byte[] buffer = new byte[]{recordData[0], recordData[1], 0, 0};
        sensorRecord.setId(TypeConverter.littleEndianByteArrayToInt(buffer));
        sensorRecord.setSdrVersion(TypeConverter.littleEndianBcdByteToInt(recordData[2]));
        sensorRecord.setRecordType(recordData[3]);
        sensorRecord.setRecordLength(TypeConverter.byteToInt(recordData[4]));
        sensorRecord.populateTypeSpecficValues(recordData, sensorRecord);
        return sensorRecord;
    }

    protected abstract void populateTypeSpecficValues(byte[] var1, SensorRecord var2);

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setSdrVersion(int sdrVersion) {
        this.sdrVersion = sdrVersion;
    }

    public int getSdrVersion() {
        return this.sdrVersion;
    }

    public void setRecordType(byte recordType) {
        this.recordType = recordType;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public void setRecordLength(int recordLength) {
        this.recordLength = recordLength;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    protected String decodeName(byte codingType, byte[] name) {
        switch ((TypeConverter.byteToInt(codingType) & 0xC0) >> 6) {
            case 0: {
                return new String(name, Charset.forName("UTF-8"));
            }
            case 1: {
                return TypeConverter.decodeBcdPlus(name);
            }
            case 2: {
                return TypeConverter.decode6bitAscii(name);
            }
            case 3: {
                return new String(name, Charset.forName("ISO-8859-1"));
            }
        }
        throw new IllegalArgumentException("Invalid coding type.");
    }
}

