/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.sdr.record;

import org.apache.log4j.Logger;

public enum SensorType {
    CoolingDevice(10),
    OtherUnitsBasedSensor(11),
    Memory(12),
    DriveBay(13),
    PostMemoryResize(14),
    SystemFirmwareProgess(15),
    EventLoggingDisabled(16),
    BootError(30),
    Watchdog1(17),
    OsBoot(31),
    SystemEvent(18),
    OsStop(32),
    CriticalInterrupt(19),
    SlotConnector(33),
    SystemAcpiPowerState(34),
    Watchdog2(35),
    PlatformAlert(36),
    EntityPresence(37),
    MonitorAsicIc(38),
    Lan(39),
    Temperature(1),
    Voltage(2),
    Current(3),
    Fan(4),
    PhysicalSecurity(5),
    PlatformSecurityViolationAttempt(6),
    Processor(7),
    PowerSupply(8),
    PowerUnit(9),
    ButtonSwitch(20),
    ModuleBoard(21),
    MicrocontrollerCoprocessor(22),
    AddInCard(23),
    Chassis(24),
    Chipset(25),
    OtherFru(26),
    ManagementSubsystemHealth(40),
    CableInterconnect(27),
    Battery(41),
    Terminator(28),
    SessionAudit(42),
    SystemBoot(29),
    VersionChange(43),
    FruState(44),
    Oem(192),
    OemReserved(118);

    private static final int COOLINGDEVICE = 10;
    private static final int OTHERUNITSBASEDSENSOR = 11;
    private static final int MEMORY = 12;
    private static final int DRIVEBAY = 13;
    private static final int POSTMEMORYRESIZE = 14;
    private static final int SYSTEMFIRMWAREPROGESS = 15;
    private static final int EVENTLOGGINGDISABLED = 16;
    private static final int BOOTERROR = 30;
    private static final int WATCHDOG1 = 17;
    private static final int OSBOOT = 31;
    private static final int SYSTEMEVENT = 18;
    private static final int OSSTOP = 32;
    private static final int CRITICALINTERRUPT = 19;
    private static final int SLOTCONNECTOR = 33;
    private static final int SYSTEMACPIPOWERSTATE = 34;
    private static final int WATCHDOG2 = 35;
    private static final int PLATFORMALERT = 36;
    private static final int ENTITYPRESENCE = 37;
    private static final int MONITORASICIC = 38;
    private static final int LAN = 39;
    private static final int TEMPERATURE = 1;
    private static final int VOLTAGE = 2;
    private static final int CURRENT = 3;
    private static final int FAN = 4;
    private static final int PHYSICALSECURITY = 5;
    private static final int PLATFORMSECURITYVIOLATIONATTEMPT = 6;
    private static final int PROCESSOR = 7;
    private static final int POWERSUPPLY = 8;
    private static final int POWERUNIT = 9;
    private static final int BUTTONSWITCH = 20;
    private static final int MODULEBOARD = 21;
    private static final int MICROCONTROLLERCOPROCESSOR = 22;
    private static final int ADDINCARD = 23;
    private static final int CHASSIS = 24;
    private static final int CHIPSET = 25;
    private static final int OTHERFRU = 26;
    private static final int MANAGEMENTSUBSYSTEMHEALTH = 40;
    private static final int CABLEINTERCONNECT = 27;
    private static final int BATTERY = 41;
    private static final int TERMINATOR = 28;
    private static final int SESSIONAUDIT = 42;
    private static final int SYSTEMBOOT = 29;
    private static final int VERSIONCHANGE = 43;
    private static final int FRUSTATE = 44;
    private static final int OEM = 192;
    private static final int OEMRESERVED = 118;
    private int code;
    private static Logger logger;

    private SensorType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static SensorType parseInt(int value) {
        switch (value) {
            case 10: {
                return CoolingDevice;
            }
            case 11: {
                return OtherUnitsBasedSensor;
            }
            case 12: {
                return Memory;
            }
            case 13: {
                return DriveBay;
            }
            case 14: {
                return PostMemoryResize;
            }
            case 15: {
                return SystemFirmwareProgess;
            }
            case 16: {
                return EventLoggingDisabled;
            }
            case 30: {
                return BootError;
            }
            case 17: {
                return Watchdog1;
            }
            case 31: {
                return OsBoot;
            }
            case 18: {
                return SystemEvent;
            }
            case 32: {
                return OsStop;
            }
            case 19: {
                return CriticalInterrupt;
            }
            case 33: {
                return SlotConnector;
            }
            case 34: {
                return SystemAcpiPowerState;
            }
            case 35: {
                return Watchdog2;
            }
            case 36: {
                return PlatformAlert;
            }
            case 37: {
                return EntityPresence;
            }
            case 38: {
                return MonitorAsicIc;
            }
            case 39: {
                return Lan;
            }
            case 1: {
                return Temperature;
            }
            case 2: {
                return Voltage;
            }
            case 3: {
                return Current;
            }
            case 4: {
                return Fan;
            }
            case 5: {
                return PhysicalSecurity;
            }
            case 6: {
                return PlatformSecurityViolationAttempt;
            }
            case 7: {
                return Processor;
            }
            case 8: {
                return PowerSupply;
            }
            case 9: {
                return PowerUnit;
            }
            case 20: {
                return ButtonSwitch;
            }
            case 21: {
                return ModuleBoard;
            }
            case 22: {
                return MicrocontrollerCoprocessor;
            }
            case 23: {
                return AddInCard;
            }
            case 24: {
                return Chassis;
            }
            case 25: {
                return Chipset;
            }
            case 26: {
                return OtherFru;
            }
            case 40: {
                return ManagementSubsystemHealth;
            }
            case 27: {
                return CableInterconnect;
            }
            case 41: {
                return Battery;
            }
            case 28: {
                return Terminator;
            }
            case 42: {
                return SessionAudit;
            }
            case 29: {
                return SystemBoot;
            }
            case 43: {
                return VersionChange;
            }
            case 44: {
                return FruState;
            }
            case 118: {
                return OemReserved;
            }
        }
        if (value >= 192) {
            return Oem;
        }
        logger.error((Object)("Invalid value: " + value));
        return Oem;
    }

    static {
        logger = Logger.getLogger(SensorType.class);
    }
}

