/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.sel;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.sel.GetSelEntryResponseData;
import com.veraxsystems.vxipmi.coding.commands.sel.SelRecord;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class GetSelEntry
extends IpmiCommandCoder {
    private int reservationId;
    private int recordId;

    public GetSelEntry(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType, int reservationId, int recordId) {
        super(version, cipherSuite, authenticationType);
        this.recordId = recordId;
        this.reservationId = reservationId;
    }

    @Override
    public byte getCommandCode() {
        return 67;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.StorageRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] payload = new byte[6];
        byte[] buffer = TypeConverter.intToByteArray(this.reservationId);
        payload[0] = buffer[3];
        payload[1] = buffer[2];
        buffer = TypeConverter.intToByteArray(this.recordId);
        payload[2] = buffer[3];
        payload[3] = buffer[2];
        payload[4] = 0;
        payload[5] = TypeConverter.intToByte(255);
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), payload, TypeConverter.intToByte(sequenceNumber % 64));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IllegalArgumentException, IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get SEL Entry command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw == null || raw.length < 3) {
            throw new IllegalArgumentException("Invalid response payload length");
        }
        GetSelEntryResponseData responseData = new GetSelEntryResponseData();
        byte[] buffer = new byte[]{raw[0], raw[1], 0, 0};
        responseData.setNextRecordId(TypeConverter.littleEndianByteArrayToInt(buffer));
        byte[] recordData = new byte[raw.length - 2];
        System.arraycopy(raw, 2, recordData, 0, recordData.length);
        responseData.setSelRecord(SelRecord.populateSelRecord(recordData));
        return responseData;
    }
}

