/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.sel;

import com.veraxsystems.vxipmi.coding.commands.sdr.record.ReadingType;
import com.veraxsystems.vxipmi.coding.commands.sdr.record.SensorType;
import com.veraxsystems.vxipmi.coding.commands.sel.EventDirection;
import com.veraxsystems.vxipmi.coding.commands.sel.SelRecordType;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.util.Date;

public class SelRecord {
    private int recordId;
    private SelRecordType recordType;
    private Date timestamp;
    private SensorType sensorType;
    private int sensorNumber;
    private EventDirection eventDirection;
    private ReadingType event;
    private byte reading;

    public static SelRecord populateSelRecord(byte[] data) {
        SelRecord record = new SelRecord();
        byte[] buffer = new byte[]{data[0], data[1], 0, 0};
        record.setRecordId(TypeConverter.littleEndianByteArrayToInt(buffer));
        record.setRecordType(SelRecordType.parseInt(TypeConverter.byteToInt(data[2])));
        System.arraycopy(data, 3, buffer, 0, 4);
        record.setTimestamp(TypeConverter.decodeDate(TypeConverter.littleEndianByteArrayToInt(buffer)));
        record.setSensorType(SensorType.parseInt(TypeConverter.byteToInt(data[10])));
        record.setSensorNumber(TypeConverter.byteToInt(data[11]));
        record.setEventDirection(EventDirection.parseInt((TypeConverter.byteToInt(data[12]) & 0x80) >> 7));
        int eventType = TypeConverter.byteToInt(data[12]) & 0x7F;
        int eventOffset = TypeConverter.byteToInt(data[13]) & 0xF;
        record.setEvent(ReadingType.parseInt(record.getSensorType(), eventType, eventOffset));
        record.setReading(data[14]);
        return record;
    }

    public void setRecordId(int recordId) {
        this.recordId = recordId;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public SelRecordType getRecordType() {
        return this.recordType;
    }

    public void setRecordType(SelRecordType recordType) {
        this.recordType = recordType;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
    }

    public int getSensorNumber() {
        return this.sensorNumber;
    }

    public void setSensorNumber(int sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    public EventDirection getEventDirection() {
        return this.eventDirection;
    }

    public void setEventDirection(EventDirection eventDirection) {
        this.eventDirection = eventDirection;
    }

    public ReadingType getEvent() {
        return this.event;
    }

    public void setEvent(ReadingType event) {
        this.event = event;
    }

    public byte getReading() {
        return this.reading;
    }

    public void setReading(byte reading) {
        this.reading = reading;
    }
}

