/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.session;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.OpenSessionResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.PlainMessage;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.coding.security.ConfidentialityNone;
import com.veraxsystems.vxipmi.common.TypeConverter;

public class OpenSession
extends IpmiCommandCoder {
    private PrivilegeLevel requestedPrivilegeLevel;
    private int sessionID;

    public void setRequestedPrivilegeLevel(PrivilegeLevel requestedPrivilegeLevel) {
        this.requestedPrivilegeLevel = requestedPrivilegeLevel;
    }

    public PrivilegeLevel getRequestedPrivilegeLevel() {
        return this.requestedPrivilegeLevel;
    }

    private byte getRequestedPrivilegeLevelEncoded() {
        switch (this.requestedPrivilegeLevel) {
            case MaximumAvailable: {
                return 0;
            }
            case Callback: {
                return TypeConverter.intToByte(1);
            }
            case User: {
                return TypeConverter.intToByte(2);
            }
            case Operator: {
                return TypeConverter.intToByte(3);
            }
            case Administrator: {
                return TypeConverter.intToByte(4);
            }
        }
        throw new IllegalArgumentException("Invalid privilege level");
    }

    public void setSessionID(int sessionID) {
        this.sessionID = sessionID;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public OpenSession(CipherSuite cipherSuite) {
        super(IpmiVersion.V20, cipherSuite, AuthenticationType.RMCPPlus);
        this.setCipherSuite(cipherSuite);
    }

    public OpenSession(int sessionID, PrivilegeLevel privilegeLevel, CipherSuite cipherSuite) {
        super(IpmiVersion.V20, cipherSuite, AuthenticationType.RMCPPlus);
        this.setSessionID(sessionID);
        this.setRequestedPrivilegeLevel(privilegeLevel);
    }

    @Override
    public IpmiMessage encodeCommand(int sequenceNumber, int sessionId) {
        if (sessionId != 0) {
            throw new IllegalArgumentException("Session ID must be 0");
        }
        Ipmiv20Message message = new Ipmiv20Message(new ConfidentialityNone());
        message.setPayloadType(PayloadType.RmcpOpenSessionRequest);
        message.setSessionID(0);
        message.setSessionSequenceNumber(0);
        message.setAuthenticationType(this.getAuthenticationType());
        message.setPayloadAuthenticated(false);
        message.setPayloadEncrypted(false);
        message.setPayload(this.preparePayload(sequenceNumber));
        return message;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) {
        byte[] payload = new byte[32];
        payload[0] = TypeConverter.intToByte(sequenceNumber % 256);
        payload[1] = this.getRequestedPrivilegeLevelEncoded();
        payload[2] = 0;
        payload[3] = 0;
        byte[] id = TypeConverter.intToLittleEndianByteArray(this.sessionID);
        System.arraycopy(id, 0, payload, 4, 4);
        payload[8] = 0;
        payload[9] = 0;
        payload[10] = 0;
        payload[11] = 8;
        payload[12] = this.getCipherSuite().getAuthenticationAlgorithm().getCode();
        payload[13] = 0;
        payload[14] = 0;
        payload[15] = 0;
        payload[16] = 1;
        payload[17] = 0;
        payload[18] = 0;
        payload[19] = 8;
        payload[20] = this.getCipherSuite().getIntegrityAlgorithm().getCode();
        payload[21] = 0;
        payload[22] = 0;
        payload[23] = 0;
        payload[24] = 2;
        payload[25] = 0;
        payload[26] = 0;
        payload[27] = 8;
        payload[28] = this.getCipherSuite().getConfidentialityAlgorithm().getCode();
        payload[29] = 0;
        payload[30] = 0;
        payload[31] = 0;
        return new PlainMessage(payload);
    }

    @Override
    @Deprecated
    public byte getCommandCode() {
        return 0;
    }

    @Override
    @Deprecated
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.ChassisRequest;
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IllegalArgumentException, IPMIException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Open Session command");
        }
        byte[] payload = message.getPayload().getPayloadData();
        if (payload[1] != 0) {
            throw new IPMIException(CompletionCode.parseInt(TypeConverter.byteToInt(payload[1])));
        }
        if (payload.length < 36) {
            throw new IllegalArgumentException("Invalid payload length");
        }
        OpenSessionResponseData data = new OpenSessionResponseData();
        data.setMessageTag(payload[0]);
        data.setStatusCode(payload[1]);
        data.setPrivilegeLevel(payload[2]);
        byte[] buffer = new byte[4];
        System.arraycopy(payload, 4, buffer, 0, 4);
        data.setRemoteConsoleSessionId(TypeConverter.littleEndianByteArrayToInt(buffer));
        System.arraycopy(payload, 8, buffer, 0, 4);
        data.setManagedSystemSessionId(TypeConverter.littleEndianByteArrayToInt(buffer));
        byte[] auth = new byte[8];
        System.arraycopy(payload, 12, auth, 0, 8);
        data.setAuthenticationAlgorithm(auth[4]);
        byte[] integr = new byte[8];
        System.arraycopy(payload, 20, integr, 0, 8);
        data.setIntegrityAlgorithm(integr[4]);
        byte[] conf = new byte[8];
        System.arraycopy(payload, 28, conf, 0, 8);
        data.setConfidentialityAlgorithm(conf[4]);
        return data;
    }
}

