/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.session;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.SetSessionPrivilegeLevelResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class SetSessionPrivilegeLevel
extends IpmiCommandCoder {
    private PrivilegeLevel privilegeLevel;

    public SetSessionPrivilegeLevel(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType, PrivilegeLevel privilegeLevel) {
        super(version, cipherSuite, authenticationType);
        this.privilegeLevel = privilegeLevel;
    }

    @Override
    public byte getCommandCode() {
        return 59;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.ApplicationRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] requestData = new byte[]{TypeConverter.intToByte(this.getRequestedPrivilegeLevelEncoded())};
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), requestData, TypeConverter.intToByte(sequenceNumber % 64));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IllegalArgumentException, IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get SEL Entry command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        return new SetSessionPrivilegeLevelResponseData();
    }

    private byte getRequestedPrivilegeLevelEncoded() {
        switch (this.privilegeLevel) {
            case MaximumAvailable: {
                return 0;
            }
            case Callback: {
                return TypeConverter.intToByte(1);
            }
            case User: {
                return TypeConverter.intToByte(2);
            }
            case Operator: {
                return TypeConverter.intToByte(3);
            }
            case Administrator: {
                return TypeConverter.intToByte(4);
            }
        }
        throw new IllegalArgumentException("Invalid privilege level");
    }
}

