/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.protocol.decoder;

import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.protocol.decoder.ProtocolDecoder;
import com.veraxsystems.vxipmi.coding.rmcp.RmcpMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.coding.security.ConfidentialityNone;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class Protocolv20Decoder
extends ProtocolDecoder {
    private static Logger logger = Logger.getLogger(Protocolv20Decoder.class);
    private CipherSuite cipherSuite;

    public Protocolv20Decoder(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    @Override
    public IpmiMessage decode(RmcpMessage rmcpMessage) throws IllegalArgumentException, InvalidKeyException {
        Ipmiv20Message message = new Ipmiv20Message(this.cipherSuite.getConfidentialityAlgorithm());
        byte[] raw = rmcpMessage.getData();
        message.setAuthenticationType(Protocolv20Decoder.decodeAuthenticationType(raw[0]));
        message.setPayloadEncrypted(this.decodeEncryption(raw[1]));
        message.setPayloadAuthenticated(this.decodeAuthentication(raw[1]));
        message.setPayloadType(Protocolv20Decoder.decodePayloadType(raw[1]));
        int offset = 2;
        if (message.getPayloadType() == PayloadType.Oem) {
            message.setOemIANA(this.decodeOEMIANA(raw));
            message.setOemPayloadID(this.decodeOEMPayloadId(raw, offset += 4));
            offset += 2;
        }
        message.setSessionID(Protocolv20Decoder.decodeSessionID(raw, offset));
        message.setSessionSequenceNumber(this.decodeSessionSequenceNumber(raw, offset += 4));
        int payloadLength = this.decodePayloadLength(raw, offset += 4);
        offset += 2;
        if (message.isPayloadEncrypted()) {
            message.setPayload(this.decodePayload(raw, offset, payloadLength, message.getConfidentialityAlgorithm()));
        } else {
            message.setPayload(this.decodePayload(raw, offset, payloadLength, new ConfidentialityNone()));
        }
        offset += payloadLength;
        if (message.getAuthenticationType() != AuthenticationType.None && (message.getAuthenticationType() != AuthenticationType.RMCPPlus || message.isPayloadAuthenticated()) && message.getSessionID() != 0) {
            offset = this.skipIntegrityPAD(raw, offset);
            message.setAuthCode(this.decodeAuthCode(raw, offset));
            if (!this.validateAuthCode(raw, offset)) {
                logger.warn((Object)"Integrity check failed");
            }
        }
        return message;
    }

    private boolean decodeEncryption(byte payloadType) {
        return (payloadType & TypeConverter.intToByte(128)) != 0;
    }

    public boolean decodeAuthentication(byte payloadType) {
        return (payloadType & TypeConverter.intToByte(64)) != 0;
    }

    public static PayloadType decodePayloadType(byte payloadType) throws IllegalArgumentException {
        return PayloadType.parseInt(TypeConverter.intToByte(payloadType & TypeConverter.intToByte(63)));
    }

    private int decodeOEMIANA(byte[] rawMessage) {
        byte[] oemIANA = new byte[4];
        System.arraycopy(rawMessage, 3, oemIANA, 0, 3);
        oemIANA[3] = 0;
        return TypeConverter.littleEndianByteArrayToInt(oemIANA);
    }

    protected Object decodeOEMPayloadId(byte[] rawMessage, int offset) {
        byte[] oemPayload = new byte[2];
        System.arraycopy(rawMessage, offset, oemPayload, 0, 2);
        return oemPayload;
    }

    @Override
    protected int decodePayloadLength(byte[] rawData, int offset) {
        byte[] payloadLength = new byte[4];
        System.arraycopy(rawData, offset, payloadLength, 0, 2);
        payloadLength[2] = 0;
        payloadLength[3] = 0;
        return TypeConverter.littleEndianByteArrayToInt(payloadLength);
    }

    private int skipIntegrityPAD(byte[] rawMessage, int offset) throws IndexOutOfBoundsException {
        int skip = 0;
        while (TypeConverter.byteToInt(rawMessage[offset + skip]) == 255) {
            ++skip;
        }
        int length = TypeConverter.byteToInt(rawMessage[offset + skip]);
        if (length != skip) {
            throw new IndexOutOfBoundsException("Message is corrupted.");
        }
        if ((offset += skip + 2) >= rawMessage.length) {
            throw new IndexOutOfBoundsException("Message is corrupted.");
        }
        return offset;
    }

    private byte[] decodeAuthCode(byte[] rawMessage, int offset) {
        byte[] authCode = new byte[rawMessage.length - offset];
        System.arraycopy(rawMessage, offset, authCode, 0, authCode.length);
        return authCode;
    }

    private boolean validateAuthCode(byte[] rawMessage, int offset) throws InvalidKeyException {
        byte[] base = new byte[offset];
        System.arraycopy(rawMessage, 0, base, 0, offset);
        byte[] authCode = null;
        if (rawMessage.length > offset) {
            authCode = new byte[rawMessage.length - offset];
            System.arraycopy(rawMessage, offset, authCode, 0, authCode.length);
        }
        return Arrays.equals(authCode, this.cipherSuite.getIntegrityAlgorithm().generateAuthCode(base));
    }

    public static int decodeSessionID(RmcpMessage message) {
        int offset = 2;
        if (Protocolv20Decoder.decodePayloadType(message.getData()[1]) == PayloadType.Oem) {
            offset += 6;
        }
        return Protocolv20Decoder.decodeSessionID(message.getData(), offset);
    }
}

