/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.rmcp;

import com.veraxsystems.vxipmi.coding.rmcp.RmcpClassOfMessage;
import com.veraxsystems.vxipmi.coding.rmcp.RmcpMessage;
import com.veraxsystems.vxipmi.coding.rmcp.RmcpVersion;
import com.veraxsystems.vxipmi.common.TypeConverter;

public final class RmcpEncoder {
    private RmcpEncoder() {
    }

    public static byte[] encode(RmcpMessage message) {
        byte[] data = new byte[message.getData().length + 4];
        data[0] = RmcpEncoder.encodeVersion(message.getVersion());
        data[1] = 0;
        data[2] = RmcpEncoder.encodeSequenceNumber(message.getSequenceNumber());
        data[3] = RmcpEncoder.encodeRMCPClassOfMessage(message.getClassOfMessage());
        RmcpEncoder.encodeData(message.getData(), data);
        return data;
    }

    private static byte encodeVersion(RmcpVersion version) {
        switch (version) {
            case RMCP1_0: {
                return 6;
            }
        }
        throw new IllegalArgumentException("Invalid RMCP version");
    }

    private static byte encodeSequenceNumber(byte sequenceNumber) {
        return sequenceNumber;
    }

    private static byte encodeRMCPClassOfMessage(RmcpClassOfMessage classOfMessage) {
        return TypeConverter.intToByte(classOfMessage.getCode());
    }

    private static void encodeData(byte[] data, byte[] message) {
        System.arraycopy(data, 0, message, 4, data.length);
    }
}

